% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_mutate.R
\name{group_mutate}
\alias{group_mutate}
\title{group_by and mutate as an atomic action.}
\usage{
group_mutate(d, groupingVars, ..., arrangeTerms = NULL, env = parent.frame())
}
\arguments{
\item{d}{data.frame}

\item{groupingVars}{character vector of column names to group by.}

\item{...}{list of dplyr::mutate() expressions.}

\item{arrangeTerms}{character optional vector of quoted column expressions to arrange by.}

\item{env}{environment to work in.}
}
\value{
d mutateed by groups
}
\description{
Group a data frame by the groupingVars and compute user summaries on
this data frame (user summaries specified in ...).  Enforces the
good dplyr pipeline design principle of keeping group_by and
mutate close together.
Author: John Mount, Win-Vector LLC.
}
\examples{


group_mutate(datasets::mtcars,
                    c("cyl", "gear"),
                    group_mean_mpg = mean(mpg),
                    group_mean_disp = mean(disp)) \%.>\%
  head(.)

group_mutate(datasets::mtcars,
                    c("cyl", "gear"),
                    rank = dplyr::row_number(),
                    arrangeTerms = "-disp") \%.>\%
  head(.)

}
