% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_se.R
\name{summarize_se}
\alias{summarize_se}
\alias{summarise_se}
\title{summarize standard interface.}
\usage{
summarize_se(.data, summarizeTerms, ..., warn = TRUE,
  env = parent.frame())

summarise_se(.data, summarizeTerms, ..., warn = TRUE,
  env = parent.frame())
}
\arguments{
\item{.data}{data.frame}

\item{summarizeTerms}{character vector of column expressions to summarize by.}

\item{...}{force later terms to be bound by name}

\item{warn}{logical, if TRUE warn about possible name collisions.}

\item{env}{environment to work in.}
}
\value{
.data with summarizeTerms summarization applied.
}
\description{
summarize a data frame by the summarizeTerms.  Accepts arbitrary text as
summarizeTerms to allow forms such as "mean(Sepal.Length)".
}
\examples{

# good
datasets::iris \%.>\%
  summarize_se(., qae(Mean_Sepal_Length := mean(Sepal.Length),
                      Max_Sepal_Length := max(Sepal.Length)))

# good
datasets::iris \%.>\%
  summarize_se(., qae(Sepal.Length := mean(Sepal.Length)))

# intentionally generates a warning
datasets::iris \%.>\%
  summarize_se(., qae(Sepal.Length := mean(Sepal.Length),
                      Max_Sepal_Length := max(Sepal.Length)))


}
\seealso{
\code{\link[dplyr]{summarize}}, \code{\link[dplyr]{summarize_at}}, \code{\link[wrapr]{:=}}
}
