% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sentometrics.R
\docType{data}
\name{list_lexicons}
\alias{list_lexicons}
\title{Built-in lexicons}
\format{
A \code{list} with all built-in lexicons, appropriately named as \code{"NAME_language(_tr)"} .
}
\source{
\href{https://doi.org/10.1007/s10579-016-9364-5}{FEEL lexicon}. Retrieved November 1, 2017.

\href{http://www.wjh.harvard.edu/~inquirer/spreadsheet_guide.htm}{GI lexicon}. Retrieved November 1, 2017.

\href{https://doi.org/10.1177/0021943608319388}{HENRY lexicon}. Retrieved
November 1, 2017.

\href{https://sraf.nd.edu/textual-analysis/resources}{LM lexicon}. Retrieved
November 1, 2017.
}
\usage{
data("list_lexicons")
}
\description{
A \code{list} containing all built-in lexicons as a \code{data.table} with two columns: a \code{x} column with the words,
and a \code{y} column with the polarities. The \code{list} element names incorporate consecutively the name and language
(based on the two-letter ISO code convention as in \code{\link[stopwords]{stopwords}}), and \code{"_tr"} as
suffix if the lexicon is translated. The translation was done via Microsoft Translator through Microsoft
Word. Only the entries that conform to the original language entry after retranslation, and those that have actually been
translated, are kept. The last condition is assumed to be fulfilled when the translation differs from the original entry.
All words are unigrams and in lowercase. The built-in lexicons are the following:

\itemize{
  \item FEEL_en_tr
  \item FEEL_fr (Abdaoui, \enc{Azé}{Aze}, Bringay and Poncelet, 2017)
  \item FEEL_nl_tr
  \item GI_en (General Inquirer, i.e. Harvard IV-4 combined with Laswell)
  \item GI_fr_tr
  \item GI_nl_tr
  \item HENRY_en (Henry, 2008)
  \item HENRY_fr_tr
  \item HENRY_nl_tr
  \item LM_en (Loughran and McDonald, 2011)
  \item LM_fr_tr
  \item LM_nl_tr
}

Other useful lexicons can be found in the \pkg{lexicon} package, more specifically the datasets preceded by
\code{hash_sentiment_}.
}
\examples{
data("list_lexicons", package = "sentometrics")
list_lexicons[c("FEEL_en_tr", "LM_en")]

}
\references{
Abdaoui, \enc{Azé}{Aze}, Bringay and Poncelet (2017). \strong{FEEL: French Expanded Emotion Lexicon}.
\emph{Language Resources & Evaluation 51, 833-855}, \url{https://doi.org/10.1007/s10579-016-9364-5}.

Henry (2008). \strong{Are investors influenced by how earnings press releases are written?}.
\emph{Journal of Business Communication 45, 363-407}, \url{https://doi.org/10.1177/0021943608319388}.

Loughran and McDonald (2011). \strong{When is a liability not a liability? Textual analysis, dictionaries, and 10-Ks}.
\emph{Journal of Finance 66, 35-65}, \url{https://doi.org/10.1111/j.1540-6261.2010.01625.x}.
}
\keyword{datasets}
