% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sentomeasures_methods.R
\name{aggregate.sento_measures}
\alias{aggregate.sento_measures}
\title{Aggregate sentiment measures}
\usage{
\method{aggregate}{sento_measures}(x, features = NULL, lexicons = NULL,
  time = NULL, do.keep = FALSE, ...)
}
\arguments{
\item{x}{a \code{sento_measures} object created using \code{\link{sento_measures}}.}

\item{features}{a \code{list} with unique features to aggregate at given name, e.g., \cr
\code{list(feat12 = c("feat1", "feat2"))}. See \code{sento_measures$features} for the exact names to use. Use \code{NULL}
(default) to apply no merging across this dimension.}

\item{lexicons}{a \code{list} with unique lexicons to aggregate at given name, e.g., \cr
\code{list(lex12 = c("lex1", "lex2"))}. See \code{sento_measures$lexicons} for the exact names to use. Use \code{NULL}
(default) to apply no merging across this dimension.}

\item{time}{a \code{list} with unique time weighting schemes to aggregate at given name, e.g., \cr
\code{list(tw12 = c("tw1", "tw2"))}. See \code{sento_measures$time} for the exact names to use. Use \code{NULL} (default)
to apply no merging across this dimension.}

\item{do.keep}{a \code{logical} indicating if the original sentiment measures should be kept (i.e., the aggregated
sentiment measures will be added to the current sentiment measures as additional indices if \code{do.keep = TRUE}).}

\item{...}{not used.}
}
\value{
A modified \code{sento_measures} object, with only the sentiment measures required, including updated information
and statistics, but the original sentiment scores \code{data.table} untouched.
}
\description{
Aggregates sentiment measures by combining across provided lexicons, features, and time weighting
schemes dimensions. The combination occurs by taking the mean of the relevant measures.
}
\examples{
data("usnews", package = "sentometrics")
data("list_lexicons", package = "sentometrics")
data("list_valence_shifters", package = "sentometrics")

# construct a sento_measures object to start with
corpus <- sento_corpus(corpusdf = usnews)
corpusSample <- quanteda::corpus_sample(corpus, size = 500)
l <- sento_lexicons(list_lexicons[c("LM_en", "HENRY_en")], list_valence_shifters[["en"]])
ctr <- ctr_agg(howTime = c("equal_weight", "linear"), by = "year", lag = 3)
sento_measures <- sento_measures(corpusSample, l, ctr)

# aggregation across specified components
smAgg <- aggregate(sento_measures,
                   time = list(W = c("equal_weight", "linear")),
                   features = list(journals = c("wsj", "wapo")),
                   do.keep = TRUE)

# aggregation in full
dims <- get_dimensions(sento_measures)
smFull <- aggregate(sento_measures,
                    lexicons = list(L = dims[["lexicons"]]),
                    time = list(T = dims[["time"]]),
                    features = list(F = dims[["features"]]))

\dontrun{
# aggregation won't work, but produces informative error message
aggregate(sento_measures,
          time = list(W = c("equal_weight", "almon1")),
          lexicons = list(LEX = c("LM_en")),
          features = list(journals = c("notInHere", "wapo")))}
}
\author{
Samuel Borms
}
