% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_s2_paths.R, R/list_sen2r_paths.R
\name{compute_s2_paths}
\alias{compute_s2_paths}
\alias{list_sen2r_paths}
\title{Compute names of S2 file to be generated}
\usage{
compute_s2_paths(
  pm,
  s2_list_l1c,
  s2_list_l2a,
  tmpdir,
  list_prods,
  force_tiles = FALSE,
  check_tmp = TRUE,
  ignorelist
)

list_sen2r_paths(
  param_list = NULL,
  gui = NA,
  preprocess = TRUE,
  s2_levels = c("l1c", "l2a"),
  sel_sensor = c("s2a", "s2b"),
  online = TRUE,
  apihub = NA,
  downloader = "builtin",
  overwrite_safe = FALSE,
  rm_safe = "no",
  step_atmcorr = "auto",
  max_cloud_safe = 100,
  timewindow = NA,
  timeperiod = "full",
  extent = NA,
  extent_name = "sen2r",
  s2tiles_selected = NA,
  s2orbits_selected = NA,
  list_prods = c("BOA"),
  list_rgb = NA,
  list_indices = NA,
  index_source = "BOA",
  rgb_ranges = NA,
  mask_type = NA,
  max_mask = 100,
  mask_smooth = 0,
  mask_buffer = 0,
  clip_on_extent = TRUE,
  extent_as_mask = FALSE,
  reference_path = NA,
  res = NA,
  res_s2 = "10m",
  unit = "Meter",
  proj = NA,
  resampling = "near",
  resampling_scl = "near",
  outformat = "GTiff",
  rgb_outformat = "GTiff",
  index_datatype = "Int16",
  compression = "DEFLATE",
  rgb_compression = "90",
  overwrite = FALSE,
  path_l1c = NA,
  path_l2a = NA,
  path_tiles = NA,
  path_merged = NA,
  path_out = NA,
  path_rgb = NA,
  path_indices = NA,
  path_subdirs = TRUE,
  thumbnails = TRUE,
  parallel = TRUE,
  processing_order = "by_step",
  use_python = TRUE,
  tmpdir = NA,
  rmtmp = TRUE,
  log = NA
)
}
\arguments{
\item{pm}{List of input parameters.}

\item{s2_list_l1c}{Names and paths of input SAFE level-1C products.}

\item{s2_list_l2a}{Names and paths of input SAFE level-2A products.}

\item{tmpdir}{Path of the temporary directory.}

\item{list_prods}{Character vector with the values of the
products to be processed (accepted values: \code{"TOA"}, \code{"BOA"}, \code{"SCL"}, \code{"TCI"},
\code{"AOT"}, \code{"WVP"}, \code{"CLD"}, \code{"SNW"}, \code{"SZA"}, \code{"OZA"}, \code{"SAA"}, \code{"OAA"}).}

\item{force_tiles}{(optional) Logical: passed to \code{safe_shortname()} (default: FALSE).}

\item{check_tmp}{(optional) Logical: if TRUE (default), temporary files
are also searched when \code{exi} names are computed;
if FALSE, only non temporary files are searched.}

\item{ignorelist}{List of output files to be ignored (generated by \code{read_ignorelist()}).}

\item{param_list}{\code{sen2r} argument (refer to \code{sen2r()} documentation).}

\item{gui}{\code{sen2r} argument (refer to \code{sen2r()} documentation).}

\item{preprocess}{\code{sen2r} argument (refer to \code{sen2r()} documentation).}

\item{s2_levels}{\code{sen2r} argument (refer to \code{sen2r()} documentation).}

\item{sel_sensor}{\code{sen2r} argument (refer to \code{sen2r()} documentation).}

\item{online}{\code{sen2r} argument (refer to \code{sen2r()} documentation).}

\item{apihub}{\code{sen2r} argument (refer to \code{sen2r()} documentation).}

\item{downloader}{\code{sen2r} argument (refer to \code{sen2r()} documentation).}

\item{overwrite_safe}{\code{sen2r} argument (refer to \code{sen2r()} documentation).}

\item{rm_safe}{\code{sen2r} argument (refer to \code{sen2r()} documentation).}

\item{step_atmcorr}{\code{sen2r} argument (refer to \code{sen2r()} documentation).}

\item{max_cloud_safe}{\code{sen2r} argument (refer to \code{sen2r()} documentation).}

\item{timewindow}{\code{sen2r} argument (refer to \code{sen2r()} documentation).}

\item{timeperiod}{\code{sen2r} argument (refer to \code{sen2r()} documentation).}

\item{extent}{\code{sen2r} argument (refer to \code{sen2r()} documentation).}

\item{extent_name}{\code{sen2r} argument (refer to \code{sen2r()} documentation).}

\item{s2tiles_selected}{\code{sen2r} argument (refer to \code{sen2r()} documentation).}

\item{s2orbits_selected}{\code{sen2r} argument (refer to \code{sen2r()} documentation).}

\item{list_rgb}{\code{sen2r} argument (refer to \code{sen2r()} documentation).}

\item{list_indices}{\code{sen2r} argument (refer to \code{sen2r()} documentation).}

\item{index_source}{\code{sen2r} argument (refer to \code{sen2r()} documentation).}

\item{rgb_ranges}{\code{sen2r} argument (refer to \code{sen2r()} documentation).}

\item{mask_type}{\code{sen2r} argument (refer to \code{sen2r()} documentation).}

\item{max_mask}{\code{sen2r} argument (refer to \code{sen2r()} documentation).}

\item{mask_smooth}{\code{sen2r} argument (refer to \code{sen2r()} documentation).}

\item{mask_buffer}{\code{sen2r} argument (refer to \code{sen2r()} documentation).}

\item{clip_on_extent}{\code{sen2r} argument (refer to \code{sen2r()} documentation).}

\item{extent_as_mask}{\code{sen2r} argument (refer to \code{sen2r()} documentation).}

\item{reference_path}{\code{sen2r} argument (refer to \code{sen2r()} documentation).}

\item{res}{\code{sen2r} argument (refer to \code{sen2r()} documentation).}

\item{res_s2}{\code{sen2r} argument (refer to \code{sen2r()} documentation).}

\item{unit}{\code{sen2r} argument (refer to \code{sen2r()} documentation).}

\item{proj}{\code{sen2r} argument (refer to \code{sen2r()} documentation).}

\item{resampling}{\code{sen2r} argument (refer to \code{sen2r()} documentation).}

\item{resampling_scl}{\code{sen2r} argument (refer to \code{sen2r()} documentation).}

\item{outformat}{\code{sen2r} argument (refer to \code{sen2r()} documentation).}

\item{rgb_outformat}{\code{sen2r} argument (refer to \code{sen2r()} documentation).}

\item{index_datatype}{\code{sen2r} argument (refer to \code{sen2r()} documentation).}

\item{compression}{\code{sen2r} argument (refer to \code{sen2r()} documentation).}

\item{rgb_compression}{\code{sen2r} argument (refer to \code{sen2r()} documentation).}

\item{overwrite}{\code{sen2r} argument (refer to \code{sen2r()} documentation).}

\item{path_l1c}{\code{sen2r} argument (refer to \code{sen2r()} documentation).}

\item{path_l2a}{\code{sen2r} argument (refer to \code{sen2r()} documentation).}

\item{path_tiles}{\code{sen2r} argument (refer to \code{sen2r()} documentation).}

\item{path_merged}{\code{sen2r} argument (refer to \code{sen2r()} documentation).}

\item{path_out}{\code{sen2r} argument (refer to \code{sen2r()} documentation).}

\item{path_rgb}{\code{sen2r} argument (refer to \code{sen2r()} documentation).}

\item{path_indices}{\code{sen2r} argument (refer to \code{sen2r()} documentation).}

\item{path_subdirs}{\code{sen2r} argument (refer to \code{sen2r()} documentation).}

\item{thumbnails}{\code{sen2r} argument (refer to \code{sen2r()} documentation).}

\item{parallel}{\code{sen2r} argument (refer to \code{sen2r()} documentation).}

\item{processing_order}{\code{sen2r} argument (refer to \code{sen2r()} documentation).}

\item{use_python}{\code{sen2r} argument (refer to \code{sen2r()} documentation).}

\item{rmtmp}{\code{sen2r} argument (refer to \code{sen2r()} documentation).}

\item{log}{\code{sen2r} argument (refer to \code{sen2r()} documentation).}
}
\value{
A nested list:
\itemize{
\item first elements are \code{exi}, \code{exp}, \code{req} and \code{new};
\item second elements deal with the processing step: \code{tiles}, \code{merged},
\code{warped}, \code{warped_nomsk}, \code{rgb}, \code{masked} and \code{indices};
\item third elements are related to output products.
}
}
\description{
\code{compute_s2_paths} is an internal function
(to be used within \code{\link[=sen2r]{sen2r()}})
which computes the names of the required output image files
(see details).
The function was split from \code{\link[=sen2r]{sen2r()}} because this code
is called twice (and to shorten the main function).

\code{list_sen2r_paths} is a wrapper of \code{sen2r()}, which runs
\code{sen2r()} until \code{compute_s2_paths()} is called, returning the same list.
It is a simple way to call \code{compute_s2_paths()} with the same arguments
if \code{sen2r()}.
}
\details{
\code{compute_s2_paths} is structured in the following way:
\enumerate{
\item Retrieve the file names expected to be present at the
end of the processing chain (element \code{exp}) and already existing (\code{exi});
\item Compute the file names expected to be created
(elements \code{req} and \code{new}, see below)
(this operation is done in reverse order).

Meaning of the elements \code{exi}, \code{exp}, \code{req} and \code{new}
(here and for all the script), which are defined foe each processing step:
\itemize{
\item \code{exi}: full names of the files already existing before launching the
processing chain;
\item \code{exp}: full names of the files expected to be present at the
end of the processing chain (already existing or not);
\item \code{req}: names of the files required by the step;
\item \code{new}: names of the required files not existing yet (expected
to be created).
}
}

With \code{overwrite=TRUE}, all these vectors are equal
because all is overwritten.
}
\note{
License: GPL 3.0
}
\references{
L. Ranghetti, M. Boschetti, F. Nutini, L. Busetto (2020).
"sen2r": An R toolbox for automatically downloading and preprocessing
Sentinel-2 satellite data. \emph{Computers & Geosciences}, 139, 104473.
\doi{10.1016/j.cageo.2020.104473}, URL: \url{https://sen2r.ranghetti.info/}.
}
\author{
Luigi Ranghetti, phD (2019) \email{luigi@ranghetti.info}
}
\keyword{internal}
