% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sen2r_getElements.R
\name{sen2r_getElements}
\alias{sen2r_getElements}
\title{Get information from S2 short name}
\usage{
sen2r_getElements(s2_names, format = "data.table", abort = TRUE)
}
\arguments{
\item{s2_names}{A vector of Sentinel-2 product names in the
sen2r naming convention.}

\item{format}{One between \code{data.table} (default), \code{data.frame} and \code{list}.}

\item{abort}{Logical parameter: if TRUE (default), the function aborts
in case any of \code{s2_names} is not recognised; if FALSE, a warning is shown,
and a list with only the element "type"='unrecognised' is returned.}
}
\value{
A data.table, data.frame or list of the output metadata.
}
\description{
This accessory function extracts metadata included in
the name of a Sentinel-2 product which follows the sen2r
naming convention (see \link{safe_shortname}).
}
\note{
License: GPL 3.0
}
\examples{
# Define product name
fs2nc_examplename <-
  "/path/of/the/product/S2A1C_20170603_022_32TQQ_TOA_20.tif"

# Return metadata
sen2r_getElements(fs2nc_examplename)
}
\references{
L. Ranghetti, M. Boschetti, F. Nutini, L. Busetto (2020).
"sen2r": An R toolbox for automatically downloading and preprocessing
Sentinel-2 satellite data. \emph{Computers & Geosciences}, 139, 104473.
\doi{10.1016/j.cageo.2020.104473}, URL: \url{http://sen2r.ranghetti.info/}.
}
\author{
Luigi Ranghetti, phD (2019) \email{luigi@ranghetti.info}
}
