% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interactions.R
\name{interaction_scaled}
\alias{interaction_scaled}
\title{\code{interaction_scaled} creates interaction measurement items by scaled product indicator approach..}
\usage{
# standardized product indicator approach as per Henseler & Chin (2010):
 interaction_scaled("factor1", "factor2")
}
\arguments{
\item{factor1}{The first factor which is subject to the interaction.}

\item{factor2}{The second factor which is subject to the interaction.}
}
\description{
This function automatically generates interaction measurement items for a PLS SEM using scaled product indicator approach.
}
\examples{
data(mobi)

# seminr syntax for creating measurement model
mobi_mm <- constructs(
  composite("Image",        multi_items("IMAG", 1:5)),
  composite("Expectation",  multi_items("CUEX", 1:3)),
  composite("Value",        multi_items("PERV", 1:2)),
  composite("Satisfaction", multi_items("CUSA", 1:3))
)
mobi_xm <- interactions(
  interaction_scaled("Image", "Expectation"),
  interaction_scaled("Image", "Value")
)

#  structural model: note that name of the interactions factor should be
#  the names of its two main factors joined by a '.' in between.
mobi_sm <- relationships(
  paths(to = "Satisfaction",
        from = c("Image", "Expectation", "Value",
                 "Image.Expectation", "Image.Value"))
)

mobi_pls <- estimate_pls(mobi, mobi_mm, mobi_xm, mobi_sm)
summary(mobi_pls)

}
\references{
Henseler & Chin (2010), A comparison of approaches for the analysis of interaction effects
between latent variables using partial least squares path modeling. Structural Equation Modeling, 17(1),82-109.
}
