% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semEff-fun.R
\name{getEff}
\alias{getEff}
\alias{dirEff}
\alias{indEff}
\alias{totEff}
\title{Get SEM Effects}
\usage{
getEff(eff, type = "orig")

dirEff(...)

indEff(...)

totEff(...)
}
\arguments{
\item{eff}{An object of class \code{"semEff"}.}

\item{type}{The type of effects to return. Must be either \code{"orig"}
(default) or \code{"boot"}.}

\item{...}{Arguments (above) to be passed to \code{getEff} from other
extractor functions.}
}
\value{
A list containing the original or bootstrapped effects for each
  response variable, as numeric vectors or matrices (respectively).
}
\description{
Extract SEM direct, indirect, and/or total effects from an
  object of class \code{"semEff"}.
}
\details{
These are simple extractor functions for effects calculated using
  \code{semEff}, intended for convenience (e.g. for use with \code{predEff}).
}
\section{Functions}{
\itemize{
\item \code{getEff}: Extract all effects.

\item \code{dirEff}: Extract direct effects.

\item \code{indEff}: Extract indirect effects.

\item \code{totEff}: Extract total effects.
}}

