% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/status.R
\name{wait_for_server}
\alias{wait_for_server}
\alias{selenium_server_available}
\alias{wait_for_selenium_available}
\alias{get_server_status}
\title{Is a selenium server instance running?}
\usage{
wait_for_server(
  server,
  port = 4444L,
  host = "localhost",
  max_time = 60,
  error = TRUE,
  verbose = FALSE,
  timeout = 20
)

selenium_server_available(
  port = 4444L,
  host = "localhost",
  verbose = FALSE,
  timeout = 20
)

wait_for_selenium_available(
  max_time = 60,
  port = 4444L,
  host = "localhost",
  error = TRUE,
  verbose = FALSE,
  timeout = 20
)

get_server_status(
  port = 4444L,
  host = "localhost",
  verbose = FALSE,
  timeout = 20
)
}
\arguments{
\item{server}{The process object returned by \code{\link[=selenium_server]{selenium_server()}}.}

\item{port}{The port that the Selenium server is using, so we can
connect to it.}

\item{host}{The host that the Selenium server is running on. This is
usually 'localhost' (i.e. Your own machine).}

\item{max_time}{The amount of time to wait for the Selenium server to
become available.}

\item{error}{Whether to throw an error if the web request fails
after the timeout is exceeded. If not, and we can't connect to a server,
\code{FALSE} is returned.}

\item{verbose}{Whether to print information about the web request that is
sent.}

\item{timeout}{How long to wait for a request to recieve a response before
throwing an error.}
}
\value{
\code{wait_for_server()} and \code{wait_for_selenium_available()} return \code{TRUE} if
the server is ready to be connected to, and throw an error otherwise.

\code{selenium_server_available()} returns \code{TRUE} if a Selenium server is
running, and \code{FALSE} otherwise.

\code{get_server_status()} returns a list that can (but may not always) contain
the following fields:
\itemize{
\item \code{ready}: Whether the server is ready to be connected to. This should
always be returned by the server.
\item \code{message}: A message about the status of the server.
\item \code{uptime}: How long the server has been running.
\item \code{nodes}: Information about the slots that the server can take.
}
}
\description{
\code{wait_for_server()} takes a server process returned by \code{\link[=selenium_server]{selenium_server()}}
and waits for it to respond to status requests. If it doesn't, then an
error is thrown detailing any errors in the response and any error messages
from the server.

\code{selenium_server_available()} returns \code{TRUE} if a Selenium server is
running on a given port and host. \code{wait_for_selenium_available()} waits
for the Selenium server to become available for a given time, throwing an
error if one does not. It is similar to \code{wait_for_server()} except that it
works with servers not created by selenium.

\code{get_server_status()}, when given a port and host, figures out whether a
Selenium server instance is running, and if so, returns its status. This is
used by \code{selenium_server_available()} to figure out if the server is
running.
}
\examples{
\dontrun{
server <- selenium_server()

wait_for_server(server)

get_server_status()

selenium_server_available()

wait_for_selenium_available()
}

}
