% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/properties.R
\name{elem_css_property}
\alias{elem_css_property}
\title{Get a CSS property of an element}
\usage{
elem_css_property(x, name, timeout = NULL)
}
\arguments{
\item{x}{A \code{selenider_element} object.}

\item{name}{The name of the CSS property to get.}

\item{timeout}{The time to wait for \code{x} to exist.}
}
\value{
A string, or \code{NULL} if the property does not exist.
}
\description{
Get a CSS property of an element (e.g. \code{"background-color"}).
Specifically, the \emph{computed} style is returned, meaning that,
for example, widths and heights will be returned in pixels, and
colours will be returned as an RGB value.
}
\examples{
\dontshow{if (selenider::selenider_available(online = FALSE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
html <- "
<p style='visibility:hidden; color:red;'>Text</p>
"

session <- minimal_selenider_session(html)

s("p") |>
  elem_css_property("visibility")

s("p") |>
  elem_css_property("color")
\dontshow{\}) # examplesIf}
}
\seealso{
Other properties: 
\code{\link{elem_attr}()},
\code{\link{elem_name}()},
\code{\link{elem_size}()},
\code{\link{elem_text}()}
}
\concept{properties}
