% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roll_sd.R
\name{roll_sd}
\alias{roll_sd}
\title{Rolling Standard Deviation with Alignment}
\usage{
roll_sd(x, n = 7, increment = 1, align = "center")
}
\arguments{
\item{x}{an \R numeric vector}

\item{n}{integer window size}

\item{increment}{integer shift to use when sliding the window to the next location}

\item{align}{window alignment, one of \code{"left"|"center"|"right"}}
}
\value{
A vector of rolling standard deviation values of the same length as \code{x}.
}
\description{
Fast rolling standard deviations with aligment using C++/Rcpp.
Additional performance gains can be achieved by skipping \code{increment} values between calculations.
}
\details{
The window size \code{n} is interpreted as the full window length.
  
Setting \code{increment} to a value greater than one will result in \code{NA}s for all skipped-over indices.

The \code{align} parameter determines the alignment of the current index within the window. Thus:
    
\itemize{
  \item{\code{align="left" [*------]} will cause the returned vector to have n-1 \code{NA} values at the right end.}
  \item{\code{align="center" [---*---]} will cause the returned vector to have (n-1)/2 \code{NA} values at either end.}
  \item{\code{align="right" [------*]} will cause the returned vector to have n-1 \code{NA} values at the left end.}
}
}
\note{
For \code{align="center"}, the window size is increased by one if necessary to guarantee an odd window size.
}

