% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/checkX13.R
\name{checkX13}
\alias{checkX13}
\title{Check the installation of X-13ARIMA-SEATS}
\usage{
checkX13(fail = FALSE, fullcheck = TRUE, htmlcheck = TRUE)
}
\arguments{
\item{fail}{logical, whether an error should interrupt the process. If
\code{FALSE}, a message is returned.}

\item{fullcheck}{logical, whether a full test should be performed. Runs
\code{Testairline.spc} (which is shiped with X-13ARIMA-SEATS) to test the
working of the binaries. Returns a message.}

\item{htmlcheck}{logical, whether the presence of the the HTML version of
X-13 should be checked.}
}
\description{
Check the installation of the binary executables of X-13ARIMA-SEATS. For
installation details, consider Section 2 of the package vignette:
\code{vignette("seas")}
}
\examples{
\dontrun{
old.path <- Sys.getenv("X13_PATH")
Sys.setenv(X13_PATH = "")  # its broken now
checkX13()

Sys.setenv(X13_PATH = old.path)  # fix it (provided it worked in the first place)
checkX13()
}
}

