% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtc_create_iso8601.R
\name{format_iso8601}
\alias{format_iso8601}
\title{Convert date/time components into ISO8601 format}
\usage{
format_iso8601(m, .cutoff_2000 = 68L)
}
\arguments{
\item{m}{A character matrix of date/time components. It must have six
named columns: \code{year}, \code{mon}, \code{mday}, \code{hour}, \code{min} and \code{sec}.}

\item{.cutoff_2000}{An integer value. Two-digit years smaller or equal to
\code{.cutoff_2000} are parsed as though starting with \code{20}, otherwise parsed as
though starting with \code{19}.}
}
\value{
A character vector with date-times following the ISO8601 format.
}
\description{
\code{\link[=format_iso8601]{format_iso8601()}} takes a character matrix of date/time components and
converts each component to ISO8601 format. In practice this entails
converting years to a four digit number, and month, day, hours, minutes and
seconds to two-digit numbers. Not available (\code{NA}) components are converted
to \code{"-"}.
}
\keyword{internal}
