% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.sdols.confidence.R
\name{plot.sdols.confidence}
\alias{plot.sdols.confidence}
\title{Confidence and Exemplar Plotting}
\usage{
\method{plot}{sdols.confidence}(x, clustering = NULL, data = NULL,
  show.labels = length(x$clustering) <= 50, ...)
}
\arguments{
\item{x}{An object of class \code{shallot.confidence}.}

\item{clustering}{A vector of cluster labels, or \code{NULL}.}

\item{data}{The data from which the distances were computed.}

\item{show.labels}{Show the items names be shown in the plot?}

\item{...}{Currently ignored.}
}
\description{
Functions to produce confidence plots (e.g., heatmaps of pairwise allocation probabilities) and exemplar plots.
}
\examples{
\donttest{

probabilities <- expectedPairwiseAllocationMatrix(iris.clusterings)
clustering <- salso(probabilities)
conf <- confidence(clustering,probabilities)
plot(conf)
plot(conf,data=iris)
}

}
\seealso{
\code{\link{expectedPairwiseAllocationMatrix}}, \code{\link{dlso}}, \code{\link{salso}}
}
\author{
David B. Dahl \email{dahl@stat.byu.edu}
}
