% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cross-val.R
\name{sdmTMB_cv}
\alias{sdmTMB_cv}
\title{Cross validation with sdmTMB models}
\usage{
sdmTMB_cv(
  formula,
  data,
  mesh_args,
  mesh = NULL,
  time = NULL,
  k_folds = 8,
  fold_ids = NULL,
  parallel = TRUE,
  use_initial_fit = FALSE,
  spde = deprecated(),
  ...
)
}
\arguments{
\item{formula}{Model formula.}

\item{data}{A data frame.}

\item{mesh_args}{Arguments for \code{\link[=make_mesh]{make_mesh()}}. If supplied, the mesh will be
reconstructed for each fold.}

\item{mesh}{Output from \code{\link[=make_mesh]{make_mesh()}}. If supplied, the mesh will be constant
across folds.}

\item{time}{The name of the time column. Leave as \code{NULL} if this is only
spatial data.}

\item{k_folds}{Number of folds.}

\item{fold_ids}{Optional vector containing user fold IDs. Can also be a
single string, e.g. \code{"fold_id"} representing the name of the variable in
\code{data}.}

\item{parallel}{If \code{TRUE} and a \code{\link[future:plan]{future::plan()}} is supplied, will be run in
parallel.}

\item{use_initial_fit}{Fit the first fold and use those parameter values
as starting values for subsequent folds? Can be faster with many folds.}

\item{spde}{\strong{Depreciated.} Use \code{mesh} instead.}

\item{...}{All other arguments required to run \code{\link[=sdmTMB]{sdmTMB()}} model with the
exception of \code{weights}, which are used to define the folds.}
}
\value{
A list:
\itemize{
\item \code{data}: Original data plus columns for fold ID, CV predicted value,
and CV log likelihood.
\item \code{models}: A list of models; one per fold.
\item \code{fold_loglik}: Sum of left-out log likelihoods per fold.
\item \code{fold_elpd}: Expected log predictive density per fold on left-out data.
\item \code{sum_loglik}: Sum of \code{fold_loglik} across all left-out data.
\item \code{elpd}: Expected log predictive density across all left-out data.
\item \code{pdHess}: Logical vector: Hessian was invertible each fold?
\item \code{converged}: Logical: all \code{pdHess} \code{TRUE}?
\item \code{max_gradients}: Max gradient per fold.
}
}
\description{
Save log likelihoods of k-fold cross-validation for sdmTMB models.
}
\details{
Parallel processing can be used by setting a \code{future::plan()}.

For example:

\if{html}{\out{<div class="sourceCode">}}\preformatted{library(future)
plan(multisession)
# now use sdmTMB_cv() ...
}\if{html}{\out{</div>}}
}
\examples{
\dontshow{if (inla_installed()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
mesh <- make_mesh(pcod, c("X", "Y"), cutoff = 25)

# Set parallel processing first if desired with the future package.
# See the Details section above.

m_cv <- sdmTMB_cv(
  density ~ 0 + depth_scaled + depth_scaled2,
  data = pcod, mesh = mesh,
  family = tweedie(link = "log"), k_folds = 2
)

m_cv$fold_elpd
m_cv$elpd

m_cv$fold_loglik
m_cv$sum_loglik

head(m_cv$data)
m_cv$models[[1]]
m_cv$max_gradients

\donttest{
# Create mesh each fold:
m_cv2 <- sdmTMB_cv(
  density ~ 0 + depth_scaled + depth_scaled2,
  data = pcod, mesh_args = list(xy_cols = c("X", "Y"), cutoff = 20),
  family = tweedie(link = "log"), k_folds = 2
)

# Use fold_ids:
m_cv3 <- sdmTMB_cv(
  density ~ 0 + depth_scaled + depth_scaled2,
  data = pcod, mesh = mesh,
  family = tweedie(link = "log"),
  fold_ids = rep(seq(1, 3), nrow(pcod))[seq(1, nrow(pcod))]
)
}
\dontshow{\}) # examplesIf}
}
