% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tvm.R
\name{dBvm}
\alias{dBvm}
\alias{constBvm}
\title{Bivariate Sine von Mises density}
\usage{
dBvm(x, mu, kappa, logConst = NULL)

constBvm(M = 25, kappa)
}
\arguments{
\item{x}{a matrix of size \code{c(nx, 2)} for evaluating the density.}

\item{mu}{two-dimensional vector of circular means.}

\item{kappa}{three-dimensional vector with concentrations
\eqn{(\kappa_1, \kappa_2, \lambda)}.}

\item{logConst}{logarithm of the normalizing constant. Computed if
\code{NULL}.}

\item{M}{number of terms considered in the series expansion used for
evaluating the normalizing constant.}
}
\value{
A vector of length \code{nx} with the evaluated density
(\code{dBvm}) or a scalar with the normaalizing constant (\code{constBvm}).
}
\description{
Evaluation of the bivariate Sine von Mises density and its
normalizing constant.
}
\details{
If \eqn{\kappa_1 = 0} or \eqn{\kappa_2 = 0} and \eqn{\lambda \neq 0},
then \code{constBvm} will perform a Monte Carlo integration of the constant.
}
\examples{
x <- seq(-pi, pi, l = 101)[-101]
plotSurface2D(x, x, f = function(x) dBvm(x = x, mu = c(0, pi / 2),
                                         kappa = c(2, 3, 1)),
             fVect = TRUE)
}
\references{
Singh, H., Hnizdo, V. and Demchuk, E. (2002) Probabilistic model
for two dependent circular variables, \emph{Biometrika}, 89(3):719--723,
\doi{10.1093/biomet/89.3.719}
}
