% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{dJp}
\alias{dJp}
\alias{constJp}
\title{Jones and Pewsey (2005)'s circular distribution}
\usage{
dJp(x, mu, kappa, psi, const = NULL)

constJp(mu, kappa, psi, M = 200)
}
\arguments{
\item{x}{evaluation angles, not necessary in \eqn{[\pi,\pi)}.}

\item{mu}{circular mean.}

\item{kappa}{non-negative concentration parameter.}

\item{psi}{shape parameter, see details.}

\item{const}{normalizing constant, computed with \code{constJp} if not provided.}

\item{M}{grid size for computing the normalizing constant by numerical integration.}
}
\value{
A vector of the same length as \code{x} containing the density.
}
\description{
Computes the circular density of Jones and Pewsey (2005).
}
\details{
Particular interesting choices for the shape parameter are:
\itemize{
\item \code{psi = -1}: gives the Wrapped Cauchy as stationary density.
\item \code{psi = 0}: is the sinusoidal drift of the vM diffusion.
\item \code{psi = 1}: gives the Cardioid as stationary density.
}
}
\examples{
x <- seq(-pi, pi, l = 200)
plot(x, x, type = "n", ylab = "Density", ylim = c(0, 0.6))
for (i in 0:20) {
  lines(x, dJp(x = x, mu = 0, kappa = 1, psi = -2 + 4 * i / 20),
        col = rainbow(21)[i + 1])
}
}
\references{
Jammalamadaka, S. R. and SenGupta, A. (2001) \emph{Topics in Circular Statistics}. World Scientific, Singapore. \url{https://doi.org/10.1142/4031}

Jones, M. C. and Pewsey, A. (2005). A family of symmetric distributions on the circle. \emph{Journal of the American Statistical Association}, 100(472):1422--1428. \url{https://doi.org/10.1198/016214505000000286}
}
