% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/change_cellstatus.R
\name{change_cellstatus}
\alias{change_cellstatus}
\title{Change anonymization status of a specific cell}
\usage{
change_cellstatus(object, specs, rule, verbose = FALSE, ...)
}
\arguments{
\item{object}{an object of class \linkS4class{sdcProblem}}

\item{specs}{input that defines which cells to query; the function expects
either (see examples below)
\itemize{
\item a named character vector: with names referring to the names of the dimensional
variables and the values to its labels. In this case each vector-element must
contain a single value (label)
\item a \code{data.frame} where the column-names refer to the names of the dimensional
variables and the values to the labels
}}

\item{rule}{scalar character vector specifying a valid
anonymization code ('u', 'z', 'x', 's') to which all the desired cells
under consideration should be set.}

\item{verbose}{scalar logical value defining verbosity, defaults to \code{FALSE}}

\item{...}{additional parameters for potential future use, currently unused.}
}
\value{
a \linkS4class{sdcProblem} object
}
\description{
Function \code{\link[=changeCellStatus]{changeCellStatus()}} allows to change|modify the anonymization state
of single table cells for objects of class \linkS4class{sdcProblem}.
}
\examples{
# load example-problem
# (same as example from ?makeProblem)
p <- sdc_testproblem(with_supps = FALSE)

# goal: set cells with region = "D" and gender != "total" as primary sensitive

# using a data.frame as input
specs <- data.frame(
  region = "D",
  gender = c("male", "female", "total")
)

# marking the cells as sensitive
p <- change_cellstatus(
  object = p,
  specs = specs,
  rule = "u"
)

# check
cell_info(p, specs = specs)

# using a named vector for a single cell to revert
# setting D/total as primary-sensitive

specs <- c(gender = "total", region = "D")

p <- change_cellstatus(
  object = p,
  specs = specs,
  rule = "s"
)

# and check again
cell_info(p, specs = specs)
}
\author{
Bernhard Meindl \email{bernhard.meindl@statistik.gv.at}
}
