% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_qq_marginals.R
\name{plot_qq_marginals}
\alias{plot_qq_marginals}
\title{Q-Q plots with distributions in the margins}
\usage{
plot_qq_marginals(
  x,
  breaks = "Sturges",
  newpage = TRUE,
  xlab = "Observed Quantiles",
  ylab = "Theoretical quantiles",
  xlim = grDevices::extendrange(c(min(x), max(x))),
  ylim = NULL,
  main = NULL,
  sub = NULL,
  axes = TRUE,
  border = TRUE,
  ...
)
}
\arguments{
\item{x}{A numeric vector}

\item{breaks}{How to compute breakpoints for the histogram. See ?hist}

\item{newpage}{(logical) Should the plot be plotted on a new page?}

\item{xlab}{Label for x-axis}

\item{ylab}{Label for y-axis}

\item{xlim}{Range of x values shown}

\item{ylim}{Range of y values shown}

\item{main}{Main title}

\item{sub}{Subtitle}

\item{axes}{(logical) Draw axes?}

\item{border}{(logical) Draw a border?}

\item{...}{Further arguments}
}
\value{
No return value. The function adds a plot to the active graphics window.
}
\description{
\code{plot_qq_marginals} creates an enhanced Q-Q plot with the observed and theoretical distributions shown in the margins of the plot.
}
\examples{
data(anchoring)
plot_qq_marginals(anchoring$everest_feet)
}
