### R code from vignette source 'intro.Rnw'

###################################################
### code chunk number 1: intro.Rnw:20-23
###################################################
library(scuba)
sversion <- read.dcf(file = system.file("DESCRIPTION", package = "scuba"),
         fields = "Version")


###################################################
### code chunk number 2: intro.Rnw:59-65
###################################################
opa <- par(mfrow=c(1,2))
d1 <- dive(c(20,20), c(5,5))
data(pedro)
plot(d1, main="", lwd=4)
plot(pedro950, main="", col.gases=1)
par(opa)


###################################################
### code chunk number 3: intro.Rnw:84-85
###################################################
d <- dive(c(18,45))


###################################################
### code chunk number 4: intro.Rnw:102-104
###################################################
d <- dive(c(18,45))
haldane(d)


###################################################
### code chunk number 5: intro.Rnw:119-123
###################################################
data(pedro)
frag <- chop.dive(pedro902, 0, 35)
hald <- haldane(frag, relative=TRUE, model="Z")
otu  <- oxtox(frag)


###################################################
### code chunk number 6: intro.Rnw:126-140
###################################################
opa <- par(mfrow=c(1,2))
pozzie <- barplot(hald,
                  xlab=paste("Tissues (ZH-L16A)", sep=""),
                  ylab="Relative saturation",
                  main=paste("Time= 35 min\n",
                    "Accumulated oxygen toxicity", round(otu, 1)),
                      ylim=range(c(0, 1.1, 1.1 * max(hald))),
                      names.arg=NULL)
mtext(side=1, at=pozzie[1], line=1, text="Fast")
mtext(side=1, at=pozzie[17], line=1, text="Slow")
abline(h=1, lty=3, col="red")
plot(pedro902)
abline(v=35, lty=2, col="green")
par(opa)


###################################################
### code chunk number 7: intro.Rnw:149-150
###################################################
hald902 <- haldane(pedro902, progressive=TRUE, relative=TRUE)


###################################################
### code chunk number 8: intro.Rnw:152-155
###################################################
persp(times.dive(pedro902), 1:8, hald902,
      theta=-45, shade=0.5, col="yellow", border=NA,
      xlab="Time", ylab="Tissue", zlab="Relative saturation")


###################################################
### code chunk number 9: intro.Rnw:162-163
###################################################
ndl(24)


###################################################
### code chunk number 10: intro.Rnw:174-176
###################################################
nitrox(0.32)
nitrox(1)


###################################################
### code chunk number 11: intro.Rnw:184-185
###################################################
mod(nitrox(0.32))


###################################################
### code chunk number 12: intro.Rnw:193-194
###################################################
nd <- dive(nitrox(0.32), c(18, 45))


###################################################
### code chunk number 13: intro.Rnw:204-207
###################################################
d <- dive(trimix(0.18, 0.45), c(40, 20), c(30,10), 9, nitrox(0.6), 
        c(9,3), c(6, 5), c(3, 11))
plot(d)


###################################################
### code chunk number 14: intro.Rnw:231-232
###################################################
detach("package:scuba")


###################################################
### code chunk number 15: intro.Rnw:235-236
###################################################
library(scuba)


###################################################
### code chunk number 16: intro.Rnw:306-307
###################################################
d <- dive(c(18, 45), c(5,3))


###################################################
### code chunk number 17: intro.Rnw:314-315
###################################################
plot(d)


###################################################
### code chunk number 18: intro.Rnw:321-322
###################################################
d


###################################################
### code chunk number 19: intro.Rnw:329-330
###################################################
summary(d)


###################################################
### code chunk number 20: intro.Rnw:353-354
###################################################
d2 <- dive(c(18, 45), c(5,3))


###################################################
### code chunk number 21: intro.Rnw:360-362
###################################################
plot(d2)
d2


###################################################
### code chunk number 22: intro.Rnw:370-371
###################################################
d3 <- dive(c(30,15),c(9,1),c(5,5),c(0,60),c(12,60),c(5,5))


###################################################
### code chunk number 23: intro.Rnw:377-378
###################################################
plot(d3)


###################################################
### code chunk number 24: intro.Rnw:435-436 (eval = FALSE)
###################################################
## mydata <- read.table("myfile.txt", header=TRUE, as.is=TRUE)


###################################################
### code chunk number 25: intro.Rnw:438-440
###################################################
data(baron)
mydata <- baron


###################################################
### code chunk number 26: intro.Rnw:467-468
###################################################
head(mydata)


###################################################
### code chunk number 27: intro.Rnw:474-475
###################################################
mydf <- mydata[ , 1:2]


###################################################
### code chunk number 28: intro.Rnw:480-482
###################################################
head(mydf)
is.character(mydf[,1])


###################################################
### code chunk number 29: intro.Rnw:493-494
###################################################
d <- dive(mydf)


###################################################
### code chunk number 30: intro.Rnw:503-504
###################################################
d <- dive(mydf, begin=NA, end=NA)


###################################################
### code chunk number 31: intro.Rnw:512-515
###################################################
data(baron)
mydf <- baron[, 1:2]
baronprof <- dive(mydf[,1:2])


###################################################
### code chunk number 32: intro.Rnw:527-529
###################################################
data(pedro)
plot(pedro902)


###################################################
### code chunk number 33: intro.Rnw:548-551
###################################################
d <- dive(c(30, 20), c(5, 3))
depths.dive(d)
times.dive(d)


###################################################
### code chunk number 34: intro.Rnw:560-562
###################################################
depths.dive(d) <- c(0, 35, 35, 5, 5, 0)
d


###################################################
### code chunk number 35: intro.Rnw:568-569
###################################################
depths.dive(d)[2:3] <- 35


###################################################
### code chunk number 36: intro.Rnw:582-583
###################################################
durations.dive(d)[2] <- 25


###################################################
### code chunk number 37: intro.Rnw:589-590
###################################################
chop.dive(d, 0, 10)


###################################################
### code chunk number 38: intro.Rnw:601-605
###################################################
data(pedro)
tim <- times.dive(pedro902)
dep <- depths.dive(pedro902)
plot(pedro902)


###################################################
### code chunk number 39: intro.Rnw:612-614
###################################################
t9 <- max(tim[dep >= 9])
t9


###################################################
### code chunk number 40: intro.Rnw:619-621
###################################################
before <- chop.dive(pedro902, 0, t9)
after <- chop.dive(pedro902, t9)


###################################################
### code chunk number 41: intro.Rnw:626-628
###################################################
newdive <- dive(before, c(9, 5), after)
plot(newdive)


###################################################
### code chunk number 42: intro.Rnw:673-675
###################################################
m <- pickmodel("USN")
m


###################################################
### code chunk number 43: intro.Rnw:688-689
###################################################
ndl(30, model="USN")


###################################################
### code chunk number 44: intro.Rnw:701-702
###################################################
bestdoubledive(40, 12, 15)


###################################################
### code chunk number 45: intro.Rnw:720-722
###################################################
d <- dive(c(18,60), c(5,5))
haldane(d)


###################################################
### code chunk number 46: intro.Rnw:733-734
###################################################
haldane(d, relative=TRUE)


###################################################
### code chunk number 47: intro.Rnw:744-752 (eval = FALSE)
###################################################
## data(pedro)
## h <- haldane(pedro902, progressive=TRUE, relative=TRUE)
## tim <- times.dive(pedro902)
## tiss <- row.names(as.data.frame(pickmodel("D")))
## ntiss <- length(tiss)
## image(tim, 1:ntiss, h, xlab="Time", ylab="Tissue", axes=FALSE)
## axis(1)
## axis(2, at=1:ntiss, labels=tiss)


###################################################
### code chunk number 48: intro.Rnw:754-760
###################################################
tim <- times.dive(pedro902)
tiss <- row.names(as.data.frame(pickmodel("D")))
ntiss <- length(tiss)
image(tim, 1:ntiss, hald902, xlab="Time", ylab="Tissue", axes=FALSE)
axis(1)
axis(2, at=1:ntiss, labels=tiss)


###################################################
### code chunk number 49: intro.Rnw:766-769 (eval = FALSE)
###################################################
## persp(tim, 1:ntiss, h,
##       theta=-45, shade=0.5, col="yellow", border=NA,
##       xlab="Time", ylab="Tissue", zlab="Relative saturation")


###################################################
### code chunk number 50: intro.Rnw:771-774
###################################################
persp(tim, 1:ntiss, hald902,
      theta=-45, shade=0.5, col="yellow", border=NA,
      xlab="Time", ylab="Tissue", zlab="Relative saturation")


###################################################
### code chunk number 51: intro.Rnw:786-800
###################################################
opa <- par(mfrow=c(1,2))
pozzie <- barplot(hald,
                  xlab=paste("Tissues (ZH-L16A)", sep=""),
                  ylab="Relative saturation",
                  main=paste("Time= 35 min\n",
                    "Accumulated oxygen toxicity", round(otu, 1)),
                      ylim=range(c(0, 1.1, 1.1 * max(hald))),
                      names.arg=NULL)
mtext(side=1, at=pozzie[1], line=1, text="Fast")
mtext(side=1, at=pozzie[17], line=1, text="Slow")
abline(h=1, lty=3, col="red")
plot(pedro902)
abline(v=35, lty=2, col="green")
par(opa)


###################################################
### code chunk number 52: intro.Rnw:809-811
###################################################
p <- ppO2(pedro902)
plot(p, type="l", ylab="PPO2 (atm)")


###################################################
### code chunk number 53: intro.Rnw:817-818
###################################################
oxtox(pedro902)


###################################################
### code chunk number 54: intro.Rnw:840-843
###################################################
nitrox(0.36)
nitrox(1)
nitrox(0.21)


###################################################
### code chunk number 55: intro.Rnw:852-853
###################################################
trimix(0.18, 0.45)


###################################################
### code chunk number 56: intro.Rnw:860-861
###################################################
summary(nitrox(0.36))


###################################################
### code chunk number 57: intro.Rnw:876-877
###################################################
ead(24, nitrox(0.32))


###################################################
### code chunk number 58: intro.Rnw:884-885
###################################################
mod(nitrox(0.36), 1.5)


###################################################
### code chunk number 59: intro.Rnw:891-892
###################################################
maxmix(40, 1.5)


###################################################
### code chunk number 60: intro.Rnw:914-915
###################################################
dive(nitrox(0.32), c(30,20))


###################################################
### code chunk number 61: intro.Rnw:923-924
###################################################
dive(c(30,20), 5, nitrox(0.36), c(5,3))


###################################################
### code chunk number 62: intro.Rnw:951-953
###################################################
dive(nitrox(0.25), c(30, 20), c(5,3), c(0, 20))
dive(nitrox(0.25), c(30, 20), c(5,3), 0, air, c(0, 20))


###################################################
### code chunk number 63: intro.Rnw:968-969
###################################################
d <- dive(c(30,20), c(5,5))


###################################################
### code chunk number 64: intro.Rnw:976-977
###################################################
tanklist(d) <- list(nitrox(0.32))


###################################################
### code chunk number 65: intro.Rnw:984-985
###################################################
d <- dive(air, c(30,40), 6, nitrox(0.5), c(6,3), c(3,3))


###################################################
### code chunk number 66: intro.Rnw:991-992
###################################################
tanklist(d) <- list(nitrox(0.32), nitrox(0.5))


###################################################
### code chunk number 67: intro.Rnw:998-999
###################################################
tanklist(d)[[1]] <- nitrox(0.32)


###################################################
### code chunk number 68: intro.Rnw:1006-1007
###################################################
tanklist(d) <- list(deep=nitrox(0.32), deco=nitrox(0.5))


###################################################
### code chunk number 69: intro.Rnw:1013-1014
###################################################
names(tanklist(d)) <- c("deep", "deco")


###################################################
### code chunk number 70: intro.Rnw:1024-1027
###################################################
TL <- list(travel=trimix(0.18, 0.45), deco=nitrox(0.6))
d <- dive(tanklist=TL, tank="travel", c(30,40), 6, 
            tank="deco", c(6,3), c(3,3))


###################################################
### code chunk number 71: intro.Rnw:1043-1044
###################################################
whichtank(d)


###################################################
### code chunk number 72: intro.Rnw:1052-1053
###################################################
whichtank(d) <- ifelse(depths.dive(d) < 3, "travel", "deco")


###################################################
### code chunk number 73: intro.Rnw:1059-1060
###################################################
whichtank(d)[depths.dive(d) > 3] <- "travel"


