% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_arrow.R
\name{add_arrow}
\alias{add_arrow}
\title{Add arrrows to an scplot}
\usage{
add_arrow(
  object,
  case = 1,
  x0,
  y0,
  x1,
  y1,
  color = "black",
  angle = 30,
  length = unit(5, "points"),
  type = "open",
  ends = "last",
  linewidth = 0.7
)
}
\arguments{
\item{object}{An scplot object (class \code{scplot}) returned from the \code{scplot()}
function.}

\item{case}{Numerical vector with the case number or character string. \code{case = "all"} for all cases.}

\item{x0}{Origin x position of the line.}

\item{y0}{Origin y position of the line.}

\item{x1}{End x position of the line.}

\item{y1}{End y position of the line.}

\item{color}{A character string or a number defining the color of an element.}

\item{angle}{Angle (in [0,360])}

\item{length}{Size of the arrow angels.}

\item{type}{One of "open" or "closed" indicating whether the arrow head
should be a closed triangle.}

\item{ends}{One of "last", "first", or "both", indicating which ends of the
line to draw arrow heads.}

\item{linewidth}{A number with the width of the line.}
}
\value{
An object of class \code{scplot} (see\code{\link[=scplot]{scplot()}}) with added element
\code{arrows}.
}
\description{
Add arrrows to an scplot
}
\examples{
p1 <- scplot(exampleAB$Anja)  |>
  add_arrow(case = 1, 2, 70, 6, 55, color = "darkred")
}
