% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scphaser.R
\name{filter_acset}
\alias{filter_acset}
\title{Filter variants and features}
\usage{
filter_acset(acset, nmincells = 5, nminvar = 2, feat_filter = FALSE)
}
\arguments{
\item{acset}{An acset list created by \code{\link{new_acset}}. It must contain
a "gt" element with transcribed genotype calls, see \code{\link{call_gt}}.}

\item{nmincells}{An integer specifying the minimum number of cells with
imbalanced allelic expression.}

\item{nminvar}{An integer specifying the minimum number of variants within a
feature.}

\item{feat_filter}{Boolean specifying if filtering should be done per feature
including an initial cell-filter removing cells with less than two variants
with imbalanced expression within the feature.}
}
\value{
acset An acset list.
}
\description{
\code{filter_acset} removes variants and features with too little data
}
\details{
The function removes variants which have less than "nmincells" cells with
imbalanced allelic expression. A cell is deemed to have imbalanced allelic
expression if its transcribed genotype is set to 0 or 2, see
\code{\link{call_gt}}. Subsequently it removes features with less than
"nminvar" variants, see \code{\link{filter_feat_nminvar}}.
}
\examples{
##create a small artificial genotype matrix
ncells = 10
paternal = c(0, 2, 0, 0, 2)
maternal = c(2, 0, 2, 2, 0)
gt = as.matrix(as.data.frame(rep(list(paternal, maternal), ncells / 2)))
vars = 1:nrow(gt)
colnames(gt) = 1:ncells
rownames(gt) = vars

##create a feature annotation data-frame
nvars = nrow(gt)
featdata = as.data.frame(matrix(cbind(rep('jfeat', nvars),
as.character(1:nvars), rep('dummy', nvars), rep('dummy', nvars)), ncol = 4,
dimnames = list(vars, c('feat', 'var', 'ref', 'alt'))), stringsAsFactors =
FALSE)

##create acset
acset = new_acset(featdata, gt = gt)

##Remove variants with imbalanced expression in less than nmincells cells and
##features with less than nminvar variants
nmincells = 5
nminvar = 2
acset_filt = filter_acset(acset, nmincells, nminvar)

}

