% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_data_handling.R
\name{range_long_to_quantile}
\alias{range_long_to_quantile}
\title{Change Data from a Range Format to a Quantile Format}
\usage{
range_long_to_quantile(data, keep_range_col = FALSE)
}
\arguments{
\item{data}{a data.frame following the specifications from
\code{\link{eval_forecasts}}) for quantile forecasts. For an example, see
\code{\link{range_example_data_long}})}

\item{keep_range_col}{keep the range and boundary columns after
transformation (default is FALSE)}
}
\value{
a data.frame in a plain quantile format
}
\description{
Transform data from a format that uses interval ranges to denote quantiles
to a format that uses quantiles only.

Given a data.frame that follows the structure shown in
\code{\link{range_example_data_long}}, the function outputs the same
data in a long format as (as shown in
\code{\link{range_example_data_long}}). This can be useful e.g. for
plotting. If you're data.frame is in a different format, consider running
\code{\link{range_long_to_wide}} first.
}
\examples{
wide <- scoringutils::range_example_data_wide
long <- scoringutils::range_wide_to_long(wide)

plain_quantile <- range_long_to_quantile(long)

}
