% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{keeprange}
\alias{keeprange}
\title{Reduce Range Dimension of a Tape}
\usage{
keeprange(pfun, keep)
}
\arguments{
\item{pfun}{An \code{Rcpp_ADFun} object.}

\item{keep}{Integers (lowest of 1, highest of \code{pfun$range}) specifying which elements of the range to keep. To keep all pass \code{keep = seq(1, pfun$range)}.}
}
\value{
An \code{Rcpp_ADFun} object.
}
\description{
Retapes an existing \code{CppAD} tape omitting some of the returned elements.
For creating this tape, the values of \code{pfun$dyntape} and \code{pfun$xtape} are used.
}
\seealso{
Other tape builders: 
\code{\link{avgrange}()},
\code{\link{fixdynamic}()},
\code{\link{fixindependent}()},
\code{\link{tape_Hessian}()},
\code{\link{tape_Jacobian}()},
\code{\link{tape_bdryw}()},
\code{\link{tape_gradoffset}()},
\code{\link{tape_logJacdet}()},
\code{\link{tape_smd}()},
\code{\link{tape_swap}()},
\code{\link{tape_uld}()}
}
\concept{tape builders}
