% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/woebin.R
\name{woebin_adj}
\alias{woebin_adj}
\title{WOE Binning Adjustment}
\usage{
woebin_adj(dt, y, bins, adj_all_var = TRUE, special_values = NULL,
  method = "tree")
}
\arguments{
\item{dt}{A data frame.}

\item{y}{Name of y variable.}

\item{bins}{A list or data frame. Binning information generated from \code{woebin}.}

\item{adj_all_var}{Logical, default is TRUE. If it is TRUE, all variables need to adjust binning breaks, otherwise, only include the variables that have more then one inflection point.}

\item{special_values}{the values specified in special_values will in separate bins. Default is NULL.}

\item{method}{optimal binning method, it should be "tree" or "chimerge". Default is "tree".}
}
\description{
\code{woebin_adj} interactively adjust the binning breaks.
}
\examples{
\dontrun{
# Load German credit data
data(germancredit)

# Example I
dt = germancredit[, c("creditability", "age.in.years", "credit.amount")]
bins = woebin(dt, y="creditability")
breaks_adj = woebin_adj(dt, y="creditability", bins)
bins_final = woebin(dt, y="creditability",
                    breaks_list=breaks_adj)

# Example II
binsII = woebin(germancredit, y="creditability")
breaks_adjII = woebin_adj(germancredit, "creditability", binsII)
bins_finalII = woebin(germancredit, y="creditability",
                    breaks_list=breaks_adjII)
}

}
\seealso{
\code{\link{woebin}}, \code{\link{woebin_ply}}, \code{\link{woebin_plot}}
}
