% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scitb1.R
\name{scitb1}
\alias{scitb1}
\title{scitb1}
\arguments{
\item{vars}{The full range of variables you don't want to compare.}

\item{fvars}{Define the categorical variables in your data.}

\item{strata}{Enter the variables to be layered. If you fill in consecutive variables, by default they will be split into 3 layers.}

\item{data}{Enter your data.}

\item{dec}{The precision of the data, which defaults to 2 decimal places.}

\item{num}{When continuous variables are layered, use it to control the number of layers, which defaults to 3.}

\item{nonnormal}{When the data belongs to a non-normal distribution, this parameter is needed to indicate which is variable is non-normally distributed.}
}
\value{
A data frame.
}
\description{
You can use it to draw a baseline table of data.
}
\details{
Table 1 represents the relationship between the baseline values of the data.
         This function can be easily done.Creates 'Table 1', i.e., description of baseline patient
         characteristics, which is essential in every medical research.
         Supports both continuous and categorical variables, as well as
         p-values and standardized mean differences.
}
\examples{
## Import data
bc<-prematurity
## Hierarchical variables converted to factors.
bc$race<-as.factor(bc$race)
###Define all variables, categorical and stratified.
allVars <-c("age", "lwt",  "smoke", "ptl", "ht", "ui", "ftv", "bwt")
fvars<-c("smoke","ht","ui")
strata<-"race"
out<-scitb1(vars=allVars,fvars=fvars,strata=strata,data=bc)
print(out)

###Stratified variables are continuous variables.
allVars <-c("race", "lwt",  "smoke", "ptl", "ht", "ui", "ftv", "bwt")
fvars<-c("smoke","ht","ui","race")
strata<-"age"
out<-scitb1(vars=allVars,fvars=fvars,strata=strata,data=bc)
print(out)
}
