% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scattermore.R
\name{scattermore}
\alias{scattermore}
\title{scattermore}
\usage{
scattermore(xy, size = c(512, 512), xlim = c(min(xy[, 1]), max(xy[,
  1])), ylim = c(min(xy[, 2]), max(xy[, 2])), rgba = c(0L, 0L, 0L,
  255L), cex = 0, output.raster = TRUE)
}
\arguments{
\item{xy}{2-column float matrix with point coordinates. As usual with
rasters in R, X axis grows right, and Y axis grows DOWN.
Flipping \code{ylim} causes the usual mathematical behavior.}

\item{size}{2-element vector integer size of the result raster,
defaults to \code{c(512,512)}.}

\item{xlim, ylim}{Float limits as usual (position of the first pixel on the
left/top, and the last pixel on the right/bottom). You can
easily flip the top/bottom to the "usual" mathematical
system by flipping the \code{ylim} vector.}

\item{rgba}{4-row matrix with color values of 0-255, or just a single 4-item
vector for \code{c(r,g,b,a)}. Best created with \code{col2rgb(..., alpha=TRUE)}.}

\item{cex}{Additional point radius in pixels, 0=single-pixel dots (fastest)}

\item{output.raster}{Output R-style raster (as.raster)? Default TRUE. Raw
array output can be used much faster,
e.g. for use with png::writePNG.}
}
\value{
Raster with the result.
}
\description{
Convert points to raster scatterplot rather quickly.
}
\examples{
library(scattermore)
plot(scattermore(cbind(rnorm(1e7),rnorm(1e7)), rgba=c(64,128,192,10)))
}
