% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scanstatistics_general.R
\name{top_clusters}
\alias{top_clusters}
\title{Get the top (non-overlappig) clusters.}
\usage{
top_clusters(x, zones, k = 5, overlapping = FALSE)
}
\arguments{
\item{x}{An object of class scanstatistics.}

\item{zones}{A list of integer vectors.}

\item{k}{An integer, the number of clusters to return.}

\item{overlapping}{Logical; should the top clusters be allowed to overlap in
the spatial dimension? The default is \code{FALSE}.}
}
\value{
A \code{tibble} with at most \eqn{k} rows, with columns 
   \code{zone, duration, score}.
}
\description{
Get the top \eqn{k} space-time clusters according to the statistic calculated
for each cluster (the maximum being the scan statistic). The default is to 
return the spatially non-overlapping clusters, i.e. those that do not have 
any locations in common.
}
\examples{
\dontrun{
set.seed(1)
table <- data.frame(zone = 1:5, duration = 1, score = 5:1)
zones <- list(1:2, 1:3, 2:5, c(1, 3), 4:5, c(1, 5))
top_clusters(list(table = table), zones, k = 4, overlapping = FALSE)
}
}
