% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiftSC.R
\name{shiftSC}
\alias{shiftSC}
\title{Shift values in a single-case data file}
\usage{
shiftSC(data, value, var)
}
\arguments{
\item{data}{A single-case data frame. See \code{\link{scdf}} to learn about this format.}

\item{value}{Number by which to shift the values}

\item{var}{Character string with the name of the target variable.
Defaults to the measurement time variable.}
}
\value{
A scdf with shifted data
}
\description{
Shifting the values might be helpful in cases where the measurement time
is given as a time variable (see example below).
}
\examples{
### Shift the measurement time for a better estimation of the intercept
ex <- shiftSC(example_A24, value = -1996)
plm(ex)
}
\seealso{
Other data manipulation functions: \code{\link{fillmissingSC}},
  \code{\link{longSCDF}}, \code{\link{outlierSC}},
  \code{\link{rankSC}}, \code{\link{scaleSC}},
  \code{\link{smoothSC}}, \code{\link{truncateSC}}
}
\concept{data manipulation functions}
