% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SCALPEL_graphics.R
\name{plotCandidateFrame}
\alias{plotCandidateFrame}
\title{Plot preliminary dictionary element from Step 1 of SCALPEL and its corresponding frame.}
\usage{
plotCandidateFrame(scalpelOutput, AzeroIndex = NULL, AIndex = NULL,
  AfilterIndex = NULL, member = NULL, videoType = "processed",
  shrinkLargest = FALSE, shrinkCutoff = NULL, Y = NULL)
}
\arguments{
\item{scalpelOutput}{An object returned by one of the SCALPEL functions:
\code{\link{scalpel}}, \code{\link{scalpelStep1}}, \code{\link{scalpelStep2}}, or \code{\link{scalpelStep3}}.}

\item{AzeroIndex}{The preliminary dictionary element of interest. The index refers to the column of \code{scalpelOutput$Azero}.
Specify only one of the following: \code{AzeroIndex}, \code{AIndex}, or \code{AfilterIndex}.}

\item{AIndex}{The dictionary element (i.e., cluster) of interest. The index refers to the column of \code{scalpelOutput$A}.
Note that the class of \code{scalpelOutput} must be \code{scalpel}, \code{scalpelStep2}, or \code{scalpelStep3} if specifying \code{AIndex}, and \code{member} must also be specified.
Specify only one of the following: \code{AzeroIndex}, \code{AIndex}, or \code{AfilterIndex}.}

\item{AfilterIndex}{The sparse group lasso component of interest. The index refers to the column of \code{scalpelOutput$Afilter}.
Note that the
class of \code{scalpelOutput} must be \code{scalpel} or \code{scalpelStep3} if specifying \code{AfilterIndex}, and \code{member} must also be specified.
Specify only one of the following: \code{AzeroIndex}, \code{AIndex}, or \code{AfilterIndex}.}

\item{member}{Which member of the cluster corresponding to \code{AIndex} or \code{AfilterIndex} to plot. Ignored if \code{AzeroIndex} is specified.}

\item{videoType}{Specify whether to plot the processed data from Step 0 (default; \code{videoType="processed"}) or raw data (\code{videoType="raw"}).
This is ignored if \code{Y} is provided.}

\item{shrinkLargest}{Logical value indicating whether the values above \code{shrinkCutoff} should be shrunk when plotting. Shrinking these values
allows us to better visualize the areas with the largest fluorescence.}

\item{shrinkCutoff}{The value above which pixel values will be shrunk. By default, this will be chosen as
\code{min(scalpelOutput$thresholdVec)}.}

\item{Y}{An object of class \code{scalpelY}, which results from running the \code{\link{getY}} function. When not specified, \code{Y}
is automatically read in, but specifying \code{Y} is recommended when the user
would like to call this function many times, as this avoids reading the video into memory repeatedly.}
}
\value{
None
}
\description{
We plot the specified preliminary dictionary element, along with the frame of Y from which the component was derived in Step 1 of SCALPEL.
}
\examples{
\dontrun{
### many of the functions in this package are interconnected so the
### easiest way to learn to use the package is by working through the vignette,
### which is available at ajpete.com/software

#assumes you have run the example for the "scalpel" function
#simplest example with default parameters:
plotCandidateFrame(scalpelOutput = scalpelOutput, AzeroIndex = 10)

#example with optional parameters:
#plot raw data instead of processed
plotCandidateFrame(scalpelOutput = scalpelOutput, AzeroIndex = 10, videoType = "raw")

#same plot but if you have video data read in already
#using 'getY' function, you can provide it
rawY = getY(scalpelOutput = scalpelOutput, videoType = "raw")
plotCandidateFrame(scalpelOutput = scalpelOutput, AzeroIndex = 10, Y = rawY)
}
}
\seealso{
\code{\link{scalpelStep1}}, \code{\link{scalpel}}
}
