% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SCALPEL_helper.R
\name{getScalpelStep0}
\alias{getScalpelStep0}
\title{Read in results from Step 0 of SCALPEL.}
\usage{
getScalpelStep0(outputFolder)
}
\arguments{
\item{outputFolder}{The existing directory where the results that the user wishes to use are saved.}
}
\value{
An object of class \code{scalpelStep0}, which can be used to run SCALPEL Step 1 using \code{\link{scalpelStep1}}
or can be used with the plotting functions \code{\link{plotFrame}}, \code{\link{plotThresholdedFrame}}, and \code{\link{plotVideoVariance}}.
}
\description{
This step allows the user to retrieve the object of class \code{scalpelStep0} for results from a previous session.
}
\examples{
\dontrun{
### many of the functions in this package are interconnected so the
### easiest way to learn to use the package is by working through the vignette,
### which is available at ajpete.com/software

#assumes you have run the example for the "scalpel" function
#folder where results were saved
outputFolder = "scalpelResults"

#read previous results in
out = getScalpelStep0(outputFolder = outputFolder)
}
}
\seealso{
\code{\link{scalpelStep0}}, \code{\link{scalpel}}
}
