% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotBP.R
\name{plotBP}
\alias{plotBP}
\title{Plot gProfileR Barplot}
\usage{
plotBP(ordered_back_all, top_bp = 10)
}
\arguments{
\item{ordered_back_all}{Output of the g:ProfileR function.}

\item{top_bp}{The number of pathways you want to plot.}
}
\value{
\code{plotBP} A barplot of the number of "top_bp" pathways, ranked by -log10(Pfdr). \cr
}
\description{
Make a barplot of the top biological factors enriched by g:ProfileR.
}
\details{
This function takes a gProfileR output and prints the top "top_bp" most significantly
enriched FDR adjusted p-values before plotting the rank of their p-values.
}
\examples{
\donttest{
data(POA_example)
 POA_generes <- POA_example$POA_generes
 POA_OR_signature <- POA_example$POA_OR_signature
 POA_Rank_signature <- POA_example$POA_Rank_signature
Signature <- as.data.frame(POA_Rank_signature)
rowname <- get_gene_symbol(Signature)
rownames(Signature) <- rowname$rowname
ordered_back_all <- gprofiler2::gost(query = rowname$rowname[1:100], organism = "mmusculus",
 ordered_query = TRUE, significant = TRUE, exclude_iea = FALSE, multi_query = FALSE,
  measure_underrepresentation = FALSE, evcodes = FALSE, user_threshold = 0.05,
   correction_method = "fdr",   numeric_ns = "", sources = c("GO:BP", "KEGG", "REAC"))  
ordered_back_all <- ordered_back_all$result
ordered_back_all <- ordered_back_all[ordered_back_all$term_size > 15
 & ordered_back_all$term_size < 2000 & ordered_back_all$intersection_size > 2,]
ordered_back_all_tf <- gprofiler2::gost(query = rowname$rowname[1:150], organism = "mmusculus",
 ordered_query = TRUE, significant = TRUE, exclude_iea = FALSE, multi_query = FALSE,
  measure_underrepresentation = FALSE, evcodes = FALSE, user_threshold = 0.05,
   correction_method = "fdr",  numeric_ns = "", sources = c("TF"))  
ordered_back_all_tf <- ordered_back_all_tf$result
ordered_back_all_tf <- ordered_back_all_tf[ordered_back_all_tf$term_size > 15 
& ordered_back_all_tf$term_size < 5000 & ordered_back_all_tf$intersection_size > 2,]
TF = ordered_back_all_tf
BP <- ordered_back_all
bp <- plotBP(BP)
tf <- make_TF_barplot(TF)

 }
}
