% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_gene_symbol.R
\name{get_gene_symbol}
\alias{get_gene_symbol}
\title{Internal -- get gene symbol from Panglao.db matrix.}
\usage{
get_gene_symbol(wilcoxon_rank_mat_t)
}
\arguments{
\item{wilcoxon_rank_mat_t}{Matrix where row names are "GeneSymbol-Ensembl" (human or mouse).}
}
\value{
List with the following elements:
\item{rowname}{Genes in the signature matrix excluding the ensemble name.}
\item{species}{"mouse" or "human" depending on appended ensembl symbols.}
}
\description{
Internal -- removes Ensembl signature appended to signature matrix from Panglao and figure out species by pre-fix Ensembl of the Ensembl ID that is appended to gene names.
}
\details{
Internal: This function removes the ENGMUS/ENGS tag from Panglao created gene names (symbol-ENGS).
From the ENSG/ENSMUS, this function determines if the species is mouse/human and returns the gene symbols.
}
\examples{

 # load signature
data(POA_example) 
POA_OR_signature <- POA_example$POA_OR_signature
symbols <- get_gene_symbol(POA_OR_signature)


}
