% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_tucker_ica.R
\name{tucker_ica_helper}
\alias{tucker_ica_helper}
\title{Helper function for running the decomposition. Use the run_tucker_ica()
wrapper function instead.}
\usage{
tucker_ica_helper(
  tensor_data,
  ranks,
  tucker_type,
  rotation_type,
  sparsity,
  projection_container = NULL
)
}
\arguments{
\item{tensor_data}{list The tensor data including donor, gene, and cell type labels
as well as the tensor array itself}

\item{ranks}{numeric The number of donor and gene factors respectively,
to decompose to using Tucker decomposition.}

\item{tucker_type}{character Set to 'regular' to run regular tucker or to 'sparse' to run tucker
with sparsity constraints}

\item{rotation_type}{character Set to 'hybrid' to optimize loadings via our hybrid
method (see paper for details). Set to 'ica_dsc' to perform ICA rotation
on resulting donor factor matrix. Set to 'ica_lds' to optimize loadings by the
ICA rotation.}

\item{sparsity}{numeric Higher indicates more sparse}

\item{projection_container}{environment A project container to store projection
data in. Currently only implemented for 'hybrid' and 'ica_dsc' rotations. (default=NULL)}
}
\value{
The list of results for tucker decomposition with donor scores matrix in first
element and loadings matrix in second element.
}
\description{
Helper function for running the decomposition. Use the run_tucker_ica()
wrapper function instead.
}
