% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{plot_levels}
\alias{plot_levels}
\title{Plot scGate filtering results by level}
\usage{
plot_levels(obj, pure.col = "green", impure.col = "gray")
}
\arguments{
\item{obj}{Gated Seurat object output of scGate filtering function}

\item{pure.col}{Color code for pure category}

\item{impure.col}{Color code for impure category}
}
\value{
UMAP plots with 'Pure'/'Impure' labels for each level of the scGate model
}
\description{
Fast plotting of gating results over each model level.
}
\examples{
scGate.model.db <- get_scGateDB()
model <- scGate.model.db$human$generic$Myeloid
# Apply scGate with this model
data(query.seurat)
query.seurat <- scGate(query.seurat, model=model,
    reduction="pca", save.levels=TRUE)
library(patchwork)     
pll <- plot_levels(query.seurat)
wrap_plots(pll)
}
