% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Object_Utilities.R
\name{Map_New_Meta}
\alias{Map_New_Meta}
\title{Create new variable from categories in meta.data}
\usage{
Map_New_Meta(seurat_object, from, new_col = NULL, ...)
}
\arguments{
\item{seurat_object}{name of Seurat object}

\item{from}{current column in meta.data to map from}

\item{new_col}{name of new column in meta.data to add new mapped variable. If NULL (default)
will return the variable. If name provided will return Seurat object with new variable added.}

\item{...}{Mapping criteria, argument names are original existing categories
in the \code{from} calumn and values are new categories in the new variable.}
}
\value{
if \code{new_col = NULL} returns factor else returns Seurat object with new variable added.
}
\description{
Designed for fast variable creation when a new variable is going to be created from existing
variable. For example, mapping multiple samples to experimental condition.
}
\examples{
\dontrun{
seurat_object <- Map_New_Meta(seurat_object, from = "orig.ident", new_col = "Treatment",
"1" = "Ctrl", "2" = "Treated", "3" = "Treated", "4" = "Ctrl")
}

}
\references{
This function is slightly modified version of LIGER function \code{\link[rliger]{mapCellMeta}}
to allow functionality with Seurat objects. \url{https://github.com/welch-lab/liger}. (License: GPL-3).
}
\concept{get_set_util}
