% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Statistics.R
\name{Median_Stats}
\alias{Median_Stats}
\title{Median Statistics}
\usage{
Median_Stats(
  seurat_object,
  group_by_var = deprecated(),
  group.by = "orig.ident",
  default_var = TRUE,
  median_var = NULL
)
}
\arguments{
\item{seurat_object}{Seurat object name.}

\item{group_by_var}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} soft-deprecated. See \code{group.by}.}

\item{group.by}{meta data column to classify samples (default = "orig.ident").}

\item{default_var}{logical.  Whether to include the default meta.data variables of: "nCount_RNA",
"nFeature_RNA", "percent_mito", "percent_ribo", "percent_mito_ribo", and "log10GenesPerUMI"
in addition to variables supplied to \code{median_var}.}

\item{median_var}{Column(s) in \verb{@meta.data} to calculate medians for in addition to defaults.
Must be of \code{class()} integer or numeric.}
}
\value{
A data.frame.
}
\description{
Get quick values for median Genes, UMIs, \%mito per cell grouped by meta.data variable.
}
\examples{
\dontrun{
med_stats <- Median_Stats(seurat_object - obj, group.by = "orig.ident")
}

}
\concept{stats}
