% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sbo_dictionary.R
\name{sbo_dictionary}
\alias{sbo_dictionary}
\alias{dictionary}
\title{Dictionaries}
\usage{
sbo_dictionary(
  corpus,
  max_size = Inf,
  target = 1,
  .preprocess = identity,
  EOS = ""
)

dictionary(
  corpus,
  max_size = Inf,
  target = 1,
  .preprocess = identity,
  EOS = ""
)
}
\arguments{
\item{corpus}{a character vector. The training corpus from which to extract
the dictionary.}

\item{max_size}{a length one numeric. If less than \code{Inf}, only the most
frequent \code{max_size} words are retained in the dictionary.}

\item{target}{a length one numeric between \code{0} and \code{1}.
If less than one, retains
only as many words as needed to cover a fraction \code{target} of the
training corpus.}

\item{.preprocess}{a function for corpus preprocessing. Takes a character
vector as input and returns a character vector.}

\item{EOS}{a length one character vector listing all (single character)
end-of-sentence tokens.}
}
\value{
A \code{sbo_dictionary} object.
}
\description{
Build dictionary from training corpus.
}
\details{
The function \code{dictionary()} is an alias for
\code{sbo_dictionary()}.

This function builds a dictionary using the most frequent words in a
training corpus. Two pruning criterions can be applied:
\enumerate{
\item Dictionary size, as implemented by the \code{max_size} argument.
\item Target coverage fraction, as implemented by the \code{target} argument.
}

If both these criterions imply non-trivial cuts, the most restrictive
critierion applies.

The \code{.preprocess} argument allows the user to apply a custom
transformation to the training corpus, before word tokenization. The
\code{EOS} argument allows to specify a set of characters to be identified
as End-Of-Sentence tokens (and thus not part of words).

The returned object is a \code{sbo_dictionary} object, which is a
character vector containing words sorted by decreasing corpus frequency.
Furthermore, the object stores as attributes the original values of
\code{.preprocess} and \code{EOS} (i.e. the function used in corpus
preprocessing and the End-Of-Sentence characters for sentence tokenization).
}
\examples{
\donttest{
# Extract dictionary from `twitter_train` corpus (all words)
dict <- sbo_dictionary(twitter_train)
# Extract dictionary from `twitter_train` corpus (top 1000 words)
dict <- sbo_dictionary(twitter_train, max_size = 1000)
# Extract dictionary from `twitter_train` corpus (coverage target = 50\%)
dict <- sbo_dictionary(twitter_train, target = 0.5)
}
}
\author{
Valerio Gherardi
}
