% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prune.R
\name{prune}
\alias{prune}
\alias{prune.sbo_kgram_freqs}
\alias{prune.sbo_predtable}
\title{Prune k-gram objects}
\usage{
prune(object, N, ...)

\method{prune}{sbo_kgram_freqs}(object, N, ...)

\method{prune}{sbo_predtable}(object, N, ...)
}
\arguments{
\item{object}{A \code{\link[sbo]{kgram_freqs}} or a
\code{\link[sbo]{sbo_predtable}} class object.}

\item{N}{a length one positive integer. N-gram order of the new object.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
an object of the same class of the input \code{object}.
}
\description{
Prune \code{M}-gram frequency tables or Stupid Back-Off prediction tables for
an \code{M}-gram model to a smaller order \code{N}.
}
\details{
This generic function provides a helper to prune M-gram frequency
tables or M-gram models, represented by \code{sbo_kgram_freqs} and
\code{sbo_predtable} objects respectively, to objects of a smaller N-gram
order, N < M. For k-gram frequency objects, frequency tables for
k > N are simply dropped. For \code{sbo_predtable}'s, the predictions coming
from the nested N-gram model are instead retained. In both cases, all other
other attributes besides k-gram order (such as the corpus preprocessing
function, or the \code{lambda} penalty in Stupid Back-Off training) are left
unchanged.
}
\examples{
# Drop k-gram frequencies for k > 2 
freqs <- twitter_freqs
summary(freqs)
freqs <- prune(freqs, N = 2)
summary(freqs)
# Extract a 2-gram model from a larger 3-gram model 
pt <- twitter_predtable
summary(pt)
pt <- prune(pt, N = 2)
summary(pt)
}
\author{
Valerio Gherardi
}
