% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/satellite.R
\docType{methods}
\name{satellite}
\alias{satellite}
\alias{satellite,RasterStack-method}
\alias{satellite,character-method}
\alias{satellite,list-method}
\title{Create a Satellite object}
\usage{
\S4method{satellite}{character}(x, meta, log)

\S4method{satellite}{RasterStack}(x, meta, log)

\S4method{satellite}{list}(x, meta, log)
}
\arguments{
\item{x}{A vector of filenames (see \code{raster::raster}) or a
\code{raster::RasterStack}.}

\item{meta}{Optional metadata object (e.g. returned from
\code{\link{compMetaLandsat}}). If x is a satellite dataset and recognised
as "Landsat", then the metadata is automatically extracted from the
respective meta information file if both the satellite data and the metadata
file follow the USGS Earth Explorer's naming convention.}

\item{log}{Optionally supply a log entry.}
}
\value{
Satellite object
}
\description{
Method to create a Satellite object.






}
\details{
A satellite object consists of three data sections:
(i) a raster data section which holds the actual data values of the
respective sensor bands, (ii) a metadata grid which holds meta information
for each sensor band (e.g. calibration coefficients, type of sensor band
etc.) and (iii) a list of log information which records the processing
history of the entire dataset.
}
\examples{
## 'character' input (i.e. filenames)
path <- system.file("extdata", package = "satellite")
files <- list.files(path, pattern = glob2rx("LC8*.tif"), full.names = TRUE)

satellite(files)

## raster::RasterStack input
satellite(l8)
}
\seealso{
\code{\link{compMetaLandsat}} to get more information about the
structure of the metadata component.
}

