% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusterSPcenters.R
\name{clusterSPcenters}
\alias{clusterSPcenters}
\title{Compute centroids/medoids for clustered snow profiles}
\usage{
clusterSPcenters(
  SPx,
  clustering,
  config,
  centers = "centroids",
  clustering_old = NULL,
  cents = NULL,
  distmat = NULL
)
}
\arguments{
\item{SPx}{a \link[sarp.snowprofile:snowprofileSet]{sarp.snowprofile::snowprofileSet} to be clustered}

\item{clustering}{vector of integers (from 1:k) indicating the cluster to which each snow profile is allocated}

\item{config}{a list providing the necessary hyperparameters for distance and average calculations. Use \link{clusterSPconfig} functions for convenience!}

\item{centers}{type of center to determine, either \code{centroids} (default) where an average profile is computed for each cluster
or \code{medoids} where the index of the medoid profile is identified}

\item{clustering_old}{same as \code{clustering} but from the previous iteration of a kdba (if provided then this function only computes new centroids when the profiles within a cluster changed)}

\item{cents}{a \link[sarp.snowprofile:snowprofileSet]{sarp.snowprofile::snowprofileSet} of centroids from the previous iteration; provide \code{NULL} if not available}

\item{distmat}{a precomputed distance matrix of class dist (for faster medoid calculations)}
}
\value{
a named \link[sarp.snowprofile:snowprofileSet]{sarp.snowprofile::snowprofileSet} of centroid/medoids profiles for each cluster where the name refers to the corresponding cluster and is sorted in ascending manner.
}
\description{
Wrapper for calculating centroids \link{averageSP} or medoids \link{medoidSP} when clustering, with efficient optimization when iterating kdba clustering calculations
}
\seealso{
\link{clusterSPkdba}, \link{dbaSP}
}
\author{
fherla shorton
}
