#' Summarize prediction results
#'
#' @description
#' Summarize the estimated mean and standard error.
#'
#' @param object A \code{sandwich.model} object generated by \code{\link{sandwich.model}}.
#' @param ... Ignored.
#'
#' @examples
#' data(sim.data)
#' sim.sw <- sandwich.model(object=sim.data, sampling.attr="Value", type="shp")
#' summary(object=sim.sw)
#'
#' @return Summarized statistics for the estimated mean and standard error.
#'
#' @seealso \code{\link{sandwich.model}}
#'
#' @name summary
#'
NULL
# ---- End of roxygen documentation ----

#' @method summary sandwich.model
#' @export
#' @rdname summary
summary.sandwich.model <- function(object, ...){

  #--------------------------- Check inputs ----------------------------------
  if (!is.element("mean", names(object$object)) |
      !is.element("se", names(object$object)) |
      !is.element("df", names(object$object))){
    stop("Should run the sandwich.model function first.")
  }

  #---------------- Summarize Sandwich estimates ----------------------
  cols = c("mean", "se")
  print(paste("Sample size: ", object$sample_size))
  print(paste("Number of SSH strata: ", object$ssh_num))
  print(paste("Number of reporting units: ", object$reporting_num))
  summary(object$object[cols])
}


