% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/salt_swap.R
\name{salt_swap}
\alias{salt_swap}
\title{Randomly swap out entire values in a vector}
\usage{
salt_swap(x, swaps, p = 0.2)
}
\arguments{
\item{x}{A vector. This will always be coerced to character during salting.}

\item{swaps}{Values to be swapped out}

\item{p}{A number between 0 and 1. Percent of values in \code{x} that should be
salted.}
}
\value{
A character vector the same length as \code{x}
}
\description{
Because \code{swaps} can be provided by either a character vector or a function
that returns a character vector, \code{salt_swap} can be fruitfully used in
conjunction with the \link[charlatan:charlatan]{charlatan::charlatan} package to intersperse real data with
simulated data.
}
\examples{
x <- c("Lorem ipsum dolor sit amet, consectetur adipiscing elit.",
       "Nunc finibus tortor a elit eleifend interdum.",
       "Maecenas aliquam augue sit amet ultricies placerat.")

new_values <- c("foo", "bar", "baz")

salt_swap(x, swaps = new_values, p = 0.5)
}
