% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.salso.estimate.R
\name{summary.salso.estimate}
\alias{summary.salso.estimate}
\title{Summary of Partitions Estimated Using Posterior Expected Loss}
\usage{
\method{summary}{salso.estimate}(object, alternative, orderingMethod = 1, ...)
}
\arguments{
\item{object}{An object returned by the \code{\link{salso}} function.}

\item{alternative}{An optional argument specifying an alternative clustering
to use instead of that provided by \code{object}. Use this feature to
obtain numerical and graphical summaries of a clustering estimate from
other procedures. This clustering must be provided in canonical form:
cluster labels as integers starting at 1 for the first observation and
incrementing by one for each new label.}

\item{orderingMethod}{An integer giving method to use to order the
observations for a heatmap plot.  Currently values \code{1} or \code{2} are
supported.}

\item{...}{Currently ignored.}
}
\value{
A list containing the estimate, the pairwise similarity matrix, the
mean pairwise similarity matrix, the score and mean pairwise similarity for
each observation, exemplar observation for each cluster, a dendrogram
object, a vector for ordering observations in the heatmap plot, the size of
each cluster, and the number of clusters.
}
\description{
Assessing the quality of clusters in a partition estimate is added by this
function. The result can then be plotted with
\code{\link{plot.salso.summary}}. The current implementation of the
calculation of these summaries is not terribly efficient and may be improved
in the future.
}
\examples{
# For examples, use 'nCores=1' per CRAN rules, but in practice omit this.
data(iris.clusterings)
draws <- iris.clusterings
# R_CARGO \dontrun{
# R_CARGO # Example disabled since Cargo was not found when installing from source package.
# R_CARGO # You can still run the example if you install Cargo. Hint: cargo::install().
est <- salso(draws, nCores=1)
summ <- summary(est)
plot(summ, type="heatmap")
plot(summ, type="mds")
plot(summ, type="pairs", data=iris)
plot(summ, type="dendrogram")
# R_CARGO }

}
