% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analytics-report.R
\name{sf_list_reports}
\alias{sf_list_reports}
\title{List reports}
\usage{
sf_list_reports(recent = TRUE, as_tbl = TRUE, verbose = FALSE)
}
\arguments{
\item{recent}{\code{logical}; an indicator of whether to return the 200 most
recently viewed reports or to invoke a query on the \code{Report} object to
return all reports in the Org. By default, this argument is set to \code{TRUE}
meaning that only the most recently viewed reports are returned because this
is the default behavior of the reports list endpoint in the Reports and
Dashboards REST API.}

\item{as_tbl}{\code{logical}; an indicator of whether to convert the parsed
JSON into a \code{tbl_df}.}

\item{verbose}{\code{logical}; an indicator of whether to print additional
detail for each API call, which is useful for debugging. More specifically, when
set to \code{TRUE} the URL, header, and body will be printed for each request,
along with additional diagnostic information where available.}
}
\value{
\code{tbl_df} by default, or a \code{list} depending on the value of
argument \code{as_tbl}
}
\description{
\lifecycle{experimental}

Displays a list of up to 200 tabular, matrix, or summary reports that you
recently viewed. To get a full list of reports by format, name, and other
fields, use a SOQL query on the Report object.
}
\note{
This function will only return up to 200 of recently viewed reports. For
a COMPLETE list you must use \code{\link{sf_query}} on the report object.
}
\examples{
\dontrun{
# return up to 200 recently viewed reports
reports <- sf_list_reports()

# return the results as a list
reports_as_list <- sf_list_reports(as_tbl=FALSE)

# to return all possible reports, which is queried from the Report object
all_reports <- sf_list_reports(recent=FALSE)
}
}
\seealso{
\href{https://developer.salesforce.com/docs/atlas.en-us.api_analytics.meta/api_analytics/sforce_analytics_rest_api_recentreportslist.htm}{Salesforce Documentation}, \href{https://developer.salesforce.com/docs/atlas.en-us.api_analytics.meta/api_analytics/sforce_analytics_rest_api_list_recentreports.htm#example_recent_reportslist}{Salesforce Example}
}
