% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkNumericColumns.R
\name{checkNumericColumns}
\alias{checkNumericColumns}
\title{Check that settings for mapping numeric data are associated with numeric columns}
\usage{
checkNumericColumns(key, settings, data)
}
\arguments{
\item{key}{a list (like those provided by \code{getSettingKeys())} defining the position of parameter in the settings object.}

\item{settings}{The settings list used to generate a chart like \code{eDISH()}}

\item{data}{A data frame to check for the specified numeric column}
}
\value{
A list containing the results of the check following the format specified in \code{validateSettings()[["checkList"]]}
}
\description{
Check that settings for mapping numeric data are associated with numeric columns
}
\examples{
testSettings<-generateSettings(standard="AdAM")
#pass ($valid == TRUE)
safetyGraphics:::checkSettingProvided(key=list("id_col"),settings=testSettings) 

#fails since filters aren't specified by default
safetyGraphics:::checkSettingProvided(key=list("filters"),settings=testSettings) 

#fails since groups aren't specified by default
safetyGraphics:::checkSettingProvided(key=list("groups",1,"value_col"),settings=testSettings) 

}
