% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/files.R
\name{get_file_details}
\alias{get_file_details}
\title{Get file details for a record}
\usage{
get_file_details(record_id)
}
\arguments{
\item{record_id}{A record id}
}
\value{
A data frame with fields: filename, dataset_access, path
   and local.
}
\description{
This function returns a list of the files associated with a record.
The access status of the record is reported, along with the local
absolute file path and whether a local copy is present. If there
is no local copy and the dataset is open access, you can use
\code{\link{download_safe_files}} to get local copies. If the dataset
is embargoed or restricted, see \code{\link{insert_dataset}}.
}
\examples{
   \donttest{
   set_example_safe_dir()
   files <- get_file_details(1400562)
   unset_example_safe_dir()
   }
}
