% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R, R/rfh.R
\name{fitrfh}
\alias{fitrfh}
\alias{fitrsfh}
\alias{fitrtfh}
\alias{fitrstfh}
\alias{fitGenericModel}
\alias{rfh,numeric,matrixORMatrix,numeric,NULL-method}
\alias{rfh,numeric,matrixORMatrix,numeric,corSAR1-method}
\alias{rfh,numeric,matrixORMatrix,numeric,corAR1-method}
\alias{rfh,numeric,matrixORMatrix,numeric,corSAR1AR1-method}
\title{Fitting Precedures}
\usage{
fitrfh(y, x, samplingVar, ...)

fitrsfh(y, x, samplingVar, W, x0Var = c(0.01, 1), ...)

fitrtfh(y, x, samplingVar, nTime, x0Var = c(0.01, 1, 1), ...)

fitrstfh(y, x, samplingVar, W, nTime, x0Var = c(0.01, 0.01, 1, 1), ...)

fitGenericModel(
  y,
  x,
  matVFun,
  fixedPointParam,
  k = 1.345,
  K = getK(k),
  x0Coef = NULL,
  x0Var = 1,
  x0Re = NULL,
  tol = 1e-06,
  maxIter = 100,
  maxIterParam = 10,
  maxIterRe = 100,
  convCrit = convCritRelative(tol),
  ...
)

\S4method{rfh}{numeric,matrixORMatrix,numeric,`NULL`}(formula, data, samplingVar, correlation = NULL, ...)

\S4method{rfh}{numeric,matrixORMatrix,numeric,corSAR1}(formula, data, samplingVar, correlation = NULL, ...)

\S4method{rfh}{numeric,matrixORMatrix,numeric,corAR1}(formula, data, samplingVar, correlation = NULL, ...)

\S4method{rfh}{numeric,matrixORMatrix,numeric,corSAR1AR1}(formula, data, samplingVar, correlation = NULL, ...)
}
\arguments{
\item{y}{(numeric) response vector}

\item{x}{([m|M]atrix) the design matrix}

\item{samplingVar}{(numeric) vector with sampling variances}

\item{...}{arguments passed to \code{fitGenericModel}}

\item{W}{(matrix) proximity matrix}

\item{x0Var}{(numeric) starting values for variance parameters}

\item{nTime}{(integer) number of time periods}

\item{matVFun}{(function) a function with one argument - the variance
parameters - constructing something like \link{variance}}

\item{fixedPointParam}{(function) a function with one argument. The vector of
model parameters. Returns a list of results of the next iteration in the
overall algorithm.}

\item{k}{(numeric) tuning constant}

\item{K}{(numeric) scaling constant}

\item{x0Coef}{(numeric) starting values for regression coefficients}

\item{x0Re}{(numeric) starting values for random effects}

\item{tol}{(numeric) numerical toloerance to be used during optimisation}

\item{maxIter}{(integer) the maximum number of iterations for model parameters.}

\item{maxIterParam}{(integer) the maximum number of iterations for each
parameter in each overall iteration}

\item{maxIterRe}{(integer) the maximum number of iterations for fitting the
random effects}

\item{convCrit}{(function) a function defining the stopping rule}

\item{formula}{(formula) a formula specifying the fixed effects part of the
model.}

\item{data}{(data.frame) a data set.}

\item{correlation}{an optional correlation structure, e.g. \link{corSAR1},
for the random effects part of the model. Default is no correlation, i.e. a
random intercept.}
}
\description{
Several fitting procedures. The arguments can be passed to these functions
using the interface in \link{rfh}. The functions here listed are the low
level implementations and are not intended for interactive use.
}
\details{
\code{fitrfh} implements the robust Fay-Herriot model; \code{fitrsfh} the
spatial, \code{fitrtfh} the temporal, and \code{fitrstfh} the spatio-temporal
extension to this model type. See \link{rfh} how to fit such models.
\code{fitGenericModel} is used by all these implementations and can be used
for possible extensions of the framework.
}
\examples{
data(milk, package = "sae")
x <- matrix(1, nrow = NROW(milk))
y <- milk$yi
samplingVar <- milk$SD^2
fitrfh(y, x, samplingVar)
}
