% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Poisson.R
\name{Poisson}
\alias{Poisson}
\title{Small Area Estimation using Hierarchical Bayesian under Poisson Distribution}
\usage{
Poisson(
  formula,
  iter.update = 3,
  iter.mcmc = 10000,
  coef,
  var.coef,
  thin = 2,
  burn.in = 2000,
  tau.u = 1,
  data
)
}
\arguments{
\item{formula}{Formula that describe the fitted model}

\item{iter.update}{Number of updates with default \code{3}}

\item{iter.mcmc}{Number of total iterations per chain with default \code{10000}}

\item{coef}{a vector contains prior initial value of Coefficient of Regression Model for fixed effect with default vector of \code{0} with the length of the number of regression coefficients}

\item{var.coef}{a vector contains prior initial value of variance of Coefficient of Regression Model with default vector of \code{1} with the length of the number of regression coefficients}

\item{thin}{Thinning rate, must be a positive integer with default \code{2}}

\item{burn.in}{Number of iterations to discard at the beginning with default \code{2000}}

\item{tau.u}{Prior initial value of inverse of Variance of area random effect with default \code{1}}

\item{data}{The data frame}
}
\value{
This function returns a list of the following objects:
   \item{Est}{A vector with the values of Small Area mean Estimates using Hierarchical bayesian method }
   \item{refVar}{Estimated random effect variances}
   \item{coefficient}{A dataframe with the estimated model coefficient}
   \item{plot}{Trace, Dencity, Autocorrelation Function Plot of MCMC samples}
}
\description{
This function is implemented to variable of interest \eqn{(y)} that assumed to be a Poisson Distribution. The data is a count data, \eqn{y = 1,2,3,...}
}
\examples{

##Load Dataset
library(CARBayesdata)
data(lipdata)
dataPoisson <- lipdata
dataPoissonNs <- lipdata
dataPoissonNs$observed[c(2,9,15,23,40)] <- NA


##Compute Fitted Model
##observed ~ pcaff


## For data without any nonsampled area

#formula = observed ~ pcaff
#v = c(1,1)
#c = c(0,0)


## Using parameter coef and var.coef
#saeHBPoisson <- Poisson(formula, coef=c,var.coef=v,iter.update=10,data=dataPoisson)

#saeHBPoisson$Est                                 #Small Area mean Estimates
#saeHBPoisson$refVar                              #Random effect variance
#saeHBPoisson$coefficient                         #coefficient
#Load Library 'coda' to execute the plot
#autocorr.plot(saeHBPoisson$plot[[3]]) is used to generate ACF Plot
#plot(saeHBPoisson$plot[[3]]) is used to generate Density and trace plot

## Do not using parameter coef and var.coef
#saeHBPoisson <- Poisson(formula,data=dataPoisson)



## For data with nonsampled area use dataPoissonNs


}
\author{
Azka Ubaidillah [aut], Ika Yuni Wulansari [aut], Zaza Yuda Perwira [aut, cre], Jayanti Wulansari [aut, cre], Fauzan Rais Arfizain [aut,cre]
}
