% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Regression.R
\name{Regression}
\alias{Regression}
\title{Compute the regression of an array on another along one dimension.}
\usage{
Regression(
  datay,
  datax,
  reg_dim = "sdate",
  formula = y ~ x,
  pval = TRUE,
  conf = TRUE,
  sign = FALSE,
  alpha = 0.05,
  na.action = na.omit,
  ncores = NULL
)
}
\arguments{
\item{datay}{An numeric array as predictand including the dimension along
which the regression is computed.}

\item{datax}{An numeric array as predictor. The dimension should be identical
as parameter 'datay'.}

\item{reg_dim}{A character string indicating the dimension along which to 
compute the regression. The default value is 'sdate'.}

\item{formula}{An object of class "formula" (see function \code{link[stats]{lm}}).}

\item{pval}{A logical value indicating whether to retrieve the p-value 
or not. The default value is TRUE.}

\item{conf}{A logical value indicating whether to retrieve the confidence 
intervals or not. The default value is TRUE.}

\item{sign}{A logical value indicating whether to compute or not the 
statistical significance of the test The default value is FALSE.}

\item{alpha}{A numeric of the significance level to be used in the 
statistical significance test. The default value is 0.05.}

\item{na.action}{A function or an integer. A function (e.g., na.omit, 
na.exclude, na.fail, na.pass) indicates what should happen when the data 
contain NAs. A numeric indicates the maximum number of NA position (it
counts as long as one of datay and datax is NA) allowed for compute 
regression. The default value is na.omit-}

\item{ncores}{An integer indicating the number of cores to use for parallel 
computation. Default value is NULL.}
}
\value{
A list containing:
\item{$regression}{
 A numeric array with same dimensions as parameter 'datay' and 'datax' except 
 the 'reg_dim' dimension, which is replaced by a 'stats' dimension containing 
 the regression coefficients from the lowest order (i.e., intercept) to 
 the highest degree. The length of the 'stats' dimension should be 
 \code{polydeg + 1}.  
}
\item{$conf.lower}{
 A numeric array with same dimensions as parameter 'daty' and 'datax' except
 the 'reg_dim' dimension, which is replaced by a 'stats' dimension containing 
 the lower value of the \code{siglev}\% confidence interval for all
 the regression coefficients with the same order as $regression. The length 
 of 'stats' dimension should be \code{polydeg + 1}. Only present if 
 \code{conf = TRUE}.
}
\item{$conf.upper}{
 A numeric array with same dimensions as parameter 'daty' and 'datax' except
 the 'reg_dim' dimension, which is replaced by a 'stats' dimension containing 
 the upper value of the \code{siglev}\% confidence interval for all
 the regression coefficients with the same order as $regression. The length 
 of 'stats' dimension should be \code{polydeg + 1}. Only present if 
 \code{conf = TRUE}.
}
\item{$p.val}{
 A numeric array with same dimensions as parameter 'daty' and 'datax' except
 the 'reg_dim' dimension, The array contains the p-value.
}
\item{sign}{
 A logical array of the statistical significance of the regression with the
 same dimensions as $regression. Only present if \code{sign = TRUE}.
}
\item{$filtered}{
 A numeric array with the same dimension as paramter 'datay' and 'datax', 
 the filtered datay from the regression onto datax along the 'reg_dim' 
 dimension.
}
}
\description{
Compute the regression of the array 'datay' on the array 'datax' along the
'reg_dim' dimension by least square fitting (default) or self-defined model. 
The function provides the slope of the regression, the intercept, and the
associated p-value and confidence interval. The filtered datay from the 
regression onto datax is also provided.\cr
The p-value relies on the F distribution, and the confidence interval relies 
on the student-T distribution.
}
\examples{
# Load sample data as in Load() example:
example(Load)
datay <- sampleData$mod[, 1, , ]
names(dim(datay)) <- c('sdate', 'ftime')
datax <- sampleData$obs[, 1, , ]
names(dim(datax)) <- c('sdate', 'ftime')
res1 <- Regression(datay, datax, formula = y~poly(x, 2, raw = TRUE))
res2 <- Regression(datay, datax, alpha = 0.1)

}
